/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.async.connection.EventLoopGroupFactory;
import org.neo4j.driver.internal.util.Iterables;

class EventLoopGroupFactoryTest {
    private EventLoopGroup eventLoopGroup;

    EventLoopGroupFactoryTest() {
    }

    @AfterEach
    void tearDown() {
        EventLoopGroupFactoryTest.shutdown(this.eventLoopGroup);
    }

    @Test
    void shouldReturnCorrectChannelClass() {
        Assertions.assertEquals(NioSocketChannel.class, (Object)EventLoopGroupFactory.channelClass());
    }

    @Test
    void shouldCreateEventLoopGroupWithSpecifiedThreadCount() {
        int threadCount = 2;
        this.eventLoopGroup = EventLoopGroupFactory.newEventLoopGroup((int)threadCount);
        Assertions.assertEquals((int)threadCount, (int)Iterables.count((Iterable)this.eventLoopGroup));
        MatcherAssert.assertThat((Object)this.eventLoopGroup, (Matcher)Matchers.instanceOf(NioEventLoopGroup.class));
    }

    @Test
    void shouldAssertNotInEventLoopThread() throws Exception {
        this.eventLoopGroup = EventLoopGroupFactory.newEventLoopGroup((int)1);
        EventLoopGroupFactory.assertNotInEventLoopThread();
        Future assertFuture = this.eventLoopGroup.submit(EventLoopGroupFactory::assertNotInEventLoopThread);
        ExecutionException error = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> assertFuture.get(30L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)error.getCause(), (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.blockingOperationInEventLoopError()));
    }

    @Test
    void shouldCheckIfEventLoopThread() throws Exception {
        this.eventLoopGroup = EventLoopGroupFactory.newEventLoopGroup((int)1);
        Thread eventLoopThread = EventLoopGroupFactoryTest.getThread(this.eventLoopGroup);
        Assertions.assertTrue((boolean)EventLoopGroupFactory.isEventLoopThread((Thread)eventLoopThread));
        Assertions.assertFalse((boolean)EventLoopGroupFactory.isEventLoopThread((Thread)Thread.currentThread()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldUseSameThreadClassAsNioEventLoopGroupDoesByDefault() throws Exception {
        NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(1);
        this.eventLoopGroup = EventLoopGroupFactory.newEventLoopGroup((int)1);
        try {
            Thread defaultThread = EventLoopGroupFactoryTest.getThread((EventLoopGroup)nioEventLoopGroup);
            Thread driverThread = EventLoopGroupFactoryTest.getThread(this.eventLoopGroup);
            Assertions.assertEquals(defaultThread.getClass(), driverThread.getClass().getSuperclass());
            Assertions.assertEquals((int)defaultThread.getPriority(), (int)driverThread.getPriority());
        }
        finally {
            EventLoopGroupFactoryTest.shutdown((EventLoopGroup)nioEventLoopGroup);
        }
    }

    private static Thread getThread(EventLoopGroup eventLoopGroup) throws Exception {
        return (Thread)eventLoopGroup.submit(Thread::currentThread).get(10L, TimeUnit.SECONDS);
    }

    private static void shutdown(EventLoopGroup group) {
        if (group != null) {
            try {
                group.shutdownGracefully().syncUninterruptibly();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

