/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.util.Collections;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.connection.HandshakeCompletedListener;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.handlers.HelloResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.request.HelloMessage;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.util.TestUtil;

class HandshakeCompletedListenerTest {
    private static final String USER_AGENT = "user-agent";
    private final EmbeddedChannel channel = new EmbeddedChannel();

    HandshakeCompletedListenerTest() {
    }

    @AfterEach
    void tearDown() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    void shouldFailConnectionInitializedPromiseWhenHandshakeFails() {
        ChannelPromise channelInitializedPromise = this.channel.newPromise();
        HandshakeCompletedListener listener = new HandshakeCompletedListener(USER_AGENT, (AuthToken)HandshakeCompletedListenerTest.authToken(), RoutingContext.EMPTY, channelInitializedPromise);
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        IOException cause = new IOException("Bad handshake");
        handshakeCompletedPromise.setFailure((Throwable)cause);
        listener.operationComplete((ChannelFuture)handshakeCompletedPromise);
        Exception error = (Exception)Assertions.assertThrows(Exception.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(channelInitializedPromise);
        });
        Assertions.assertEquals((Object)cause, (Object)error);
    }

    @Test
    void shouldWriteInitializationMessageInBoltV3WhenHandshakeCompleted() {
        this.testWritingOfInitializationMessage(BoltProtocolV3.VERSION, (Message)new HelloMessage(USER_AGENT, HandshakeCompletedListenerTest.authToken().toMap(), Collections.emptyMap(), false), HelloResponseHandler.class);
    }

    private void testWritingOfInitializationMessage(BoltProtocolVersion protocolVersion, Message expectedMessage, Class<? extends ResponseHandler> handlerType) {
        InboundMessageDispatcher messageDispatcher = (InboundMessageDispatcher)Mockito.mock(InboundMessageDispatcher.class);
        ChannelAttributes.setProtocolVersion((Channel)this.channel, (BoltProtocolVersion)protocolVersion);
        ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)messageDispatcher);
        ChannelPromise channelInitializedPromise = this.channel.newPromise();
        HandshakeCompletedListener listener = new HandshakeCompletedListener(USER_AGENT, (AuthToken)HandshakeCompletedListenerTest.authToken(), RoutingContext.EMPTY, channelInitializedPromise);
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        handshakeCompletedPromise.setSuccess();
        listener.operationComplete((ChannelFuture)handshakeCompletedPromise);
        Assertions.assertTrue((boolean)this.channel.finish());
        ((InboundMessageDispatcher)Mockito.verify((Object)messageDispatcher)).enqueue((ResponseHandler)ArgumentMatchers.any(handlerType));
        Object outboundMessage = this.channel.readOutbound();
        Assertions.assertEquals((Object)expectedMessage, (Object)outboundMessage);
    }

    private static InternalAuthToken authToken() {
        return (InternalAuthToken)AuthTokens.basic((String)"neo4j", (String)"secret");
    }
}

