/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.async.inbound.MessageDecoder;
import org.neo4j.driver.util.TestUtil;

class MessageDecoderTest {
    private final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new MessageDecoder()});

    MessageDecoderTest() {
    }

    @AfterEach
    void tearDown() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    void shouldDecodeMessageWithSingleChunk() {
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5})}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[0])}));
        Assertions.assertTrue((boolean)this.channel.finish());
        Assertions.assertEquals((int)1, (int)this.channel.inboundMessages().size());
        TestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5}), (ByteBuf)this.channel.readInbound());
    }

    @Test
    void shouldDecodeMessageWithMultipleChunks() {
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3})}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{4, 5})}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{6, 7, 8})}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[0])}));
        Assertions.assertTrue((boolean)this.channel.finish());
        Assertions.assertEquals((int)1, (int)this.channel.inboundMessages().size());
        TestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8}), (ByteBuf)this.channel.readInbound());
    }

    @Test
    void shouldDecodeMultipleConsecutiveMessages() {
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3})});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[0])});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{4, 5})});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{6})});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[0])});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{7, 8})});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{9, 10})});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[0])});
        Assertions.assertEquals((int)3, (int)this.channel.inboundMessages().size());
        TestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}), (ByteBuf)this.channel.readInbound());
        TestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}), (ByteBuf)this.channel.readInbound());
        TestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 9, 10}), (ByteBuf)this.channel.readInbound());
    }
}

