/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.util.concurrent.EventExecutor;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DefaultDomainNameResolver;
import org.neo4j.driver.internal.DomainNameResolver;
import org.neo4j.driver.internal.async.connection.BootstrapFactory;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.async.connection.ChannelConnectorImpl;
import org.neo4j.driver.internal.async.pool.NettyChannelPool;
import org.neo4j.driver.internal.async.pool.NettyChannelTracker;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.metrics.DevNullMetricsListener;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.FakeClock;
import org.neo4j.driver.internal.util.ImmediateSchedulingEventExecutor;
import org.neo4j.driver.net.ServerAddress;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.TestUtil;

@ParallelizableIT
class NettyChannelPoolIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private Bootstrap bootstrap;
    private NettyChannelTracker poolHandler;
    private NettyChannelPool pool;

    NettyChannelPoolIT() {
    }

    @BeforeEach
    void setUp() {
        this.bootstrap = BootstrapFactory.newBootstrap((int)1);
        this.poolHandler = (NettyChannelTracker)Mockito.mock(NettyChannelTracker.class);
    }

    @AfterEach
    void tearDown() {
        if (this.pool != null) {
            this.pool.close();
        }
        if (this.bootstrap != null) {
            this.bootstrap.config().group().shutdownGracefully().syncUninterruptibly();
        }
    }

    @Test
    void shouldAcquireAndReleaseWithCorrectCredentials() throws Exception {
        this.pool = this.newPool(neo4j.authToken());
        Channel channel = (Channel)TestUtil.await(this.pool.acquire());
        Assertions.assertNotNull((Object)channel);
        ((NettyChannelTracker)Mockito.verify((Object)this.poolHandler)).channelCreated((Channel)ArgumentMatchers.eq((Object)channel), (ListenerEvent)ArgumentMatchers.any());
        ((NettyChannelTracker)Mockito.verify((Object)this.poolHandler, (VerificationMode)Mockito.never())).channelReleased(channel);
        TestUtil.await(this.pool.release(channel));
        ((NettyChannelTracker)Mockito.verify((Object)this.poolHandler)).channelReleased(channel);
    }

    @Test
    void shouldFailToAcquireWithWrongCredentials() throws Exception {
        this.pool = this.newPool(AuthTokens.basic((String)"wrong", (String)"wrong"));
        Assertions.assertThrows(AuthenticationException.class, () -> {
            Channel cfr_ignored_0 = (Channel)TestUtil.await(this.pool.acquire());
        });
        ((NettyChannelTracker)Mockito.verify((Object)this.poolHandler, (VerificationMode)Mockito.never())).channelCreated((Channel)ArgumentMatchers.any());
        ((NettyChannelTracker)Mockito.verify((Object)this.poolHandler, (VerificationMode)Mockito.never())).channelReleased((Channel)ArgumentMatchers.any());
    }

    @Test
    void shouldAllowAcquireAfterFailures() throws Exception {
        int maxConnections = 2;
        HashMap<String, Value> authTokenMap = new HashMap<String, Value>();
        authTokenMap.put("scheme", Values.value((String)"basic"));
        authTokenMap.put("principal", Values.value((String)"neo4j"));
        authTokenMap.put("credentials", Values.value((String)"wrong"));
        InternalAuthToken authToken = new InternalAuthToken(authTokenMap);
        this.pool = this.newPool((AuthToken)authToken, maxConnections);
        for (int i = 0; i < maxConnections; ++i) {
            AuthenticationException authenticationException = (AuthenticationException)Assertions.assertThrows(AuthenticationException.class, () -> NettyChannelPoolIT.acquire(this.pool));
        }
        authTokenMap.put("credentials", Values.value((String)neo4j.adminPassword()));
        Assertions.assertNotNull((Object)NettyChannelPoolIT.acquire(this.pool));
    }

    @Test
    void shouldLimitNumberOfConcurrentConnections() throws Exception {
        int maxConnections = 5;
        this.pool = this.newPool(neo4j.authToken(), maxConnections);
        for (int i = 0; i < maxConnections; ++i) {
            Assertions.assertNotNull((Object)NettyChannelPoolIT.acquire(this.pool));
        }
        TimeoutException e = (TimeoutException)Assertions.assertThrows(TimeoutException.class, () -> NettyChannelPoolIT.acquire(this.pool));
        Assertions.assertEquals((Object)e.getMessage(), (Object)"Acquire operation took longer then configured maximum time");
    }

    @Test
    void shouldTrackActiveChannels() throws Exception {
        NettyChannelTracker tracker;
        this.poolHandler = tracker = new NettyChannelTracker((MetricsListener)DevNullMetricsListener.INSTANCE, (EventExecutor)new ImmediateSchedulingEventExecutor(), DevNullLogging.DEV_NULL_LOGGING);
        this.pool = this.newPool(neo4j.authToken());
        Channel channel1 = NettyChannelPoolIT.acquire(this.pool);
        Channel channel2 = NettyChannelPoolIT.acquire(this.pool);
        Channel channel3 = NettyChannelPoolIT.acquire(this.pool);
        Assertions.assertEquals((int)3, (int)tracker.inUseChannelCount((ServerAddress)neo4j.address()));
        this.release(channel1);
        this.release(channel2);
        this.release(channel3);
        Assertions.assertEquals((int)0, (int)tracker.inUseChannelCount((ServerAddress)neo4j.address()));
        Assertions.assertNotNull((Object)NettyChannelPoolIT.acquire(this.pool));
        Assertions.assertNotNull((Object)NettyChannelPoolIT.acquire(this.pool));
        Assertions.assertEquals((int)2, (int)tracker.inUseChannelCount((ServerAddress)neo4j.address()));
    }

    private NettyChannelPool newPool(AuthToken authToken) {
        return this.newPool(authToken, 100);
    }

    private NettyChannelPool newPool(AuthToken authToken, int maxConnections) {
        ConnectionSettings settings = new ConnectionSettings(authToken, "test", 5000);
        ChannelConnectorImpl connector = new ChannelConnectorImpl(settings, SecurityPlanImpl.insecure(), DevNullLogging.DEV_NULL_LOGGING, (Clock)new FakeClock(), RoutingContext.EMPTY, (DomainNameResolver)DefaultDomainNameResolver.getInstance());
        return new NettyChannelPool(neo4j.address(), (ChannelConnector)connector, this.bootstrap, this.poolHandler, ChannelHealthChecker.ACTIVE, 1000L, maxConnections);
    }

    private static Channel acquire(NettyChannelPool pool) throws Exception {
        return (Channel)TestUtil.await(pool.acquire());
    }

    private void release(Channel channel) throws Exception {
        TestUtil.await(this.pool.release(channel));
    }
}

