/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.Record;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.cluster.SingleDatabaseRoutingProcedureRunner;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.util.TestUtil;

abstract class AbstractRoutingProcedureRunnerTest {
    AbstractRoutingProcedureRunnerTest() {
    }

    @Test
    void shouldReturnFailedResponseOnClientException() {
        ClientException error = new ClientException("Hi");
        SingleDatabaseRoutingProcedureRunner runner = this.singleDatabaseRoutingProcedureRunner(RoutingContext.EMPTY, Futures.failedFuture((Throwable)error));
        RoutingProcedureResponse response = (RoutingProcedureResponse)TestUtil.await(runner.run(AbstractRoutingProcedureRunnerTest.connection(), DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
        Assertions.assertFalse((boolean)response.isSuccess());
        Assertions.assertEquals((Object)((Object)error), (Object)response.error());
    }

    @Test
    void shouldReturnFailedStageOnError() {
        Exception error = new Exception("Hi");
        SingleDatabaseRoutingProcedureRunner runner = this.singleDatabaseRoutingProcedureRunner(RoutingContext.EMPTY, Futures.failedFuture((Throwable)error));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            RoutingProcedureResponse cfr_ignored_0 = (RoutingProcedureResponse)TestUtil.await(runner.run(AbstractRoutingProcedureRunnerTest.connection(), DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
        });
        Assertions.assertEquals((Object)error, (Object)e);
    }

    @Test
    void shouldReleaseConnectionOnSuccess() {
        SingleDatabaseRoutingProcedureRunner runner = this.singleDatabaseRoutingProcedureRunner(RoutingContext.EMPTY);
        Connection connection = AbstractRoutingProcedureRunnerTest.connection();
        RoutingProcedureResponse response = (RoutingProcedureResponse)TestUtil.await(runner.run(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
        Assertions.assertTrue((boolean)response.isSuccess());
        ((Connection)Mockito.verify((Object)connection)).release();
    }

    @Test
    void shouldPropagateReleaseError() {
        SingleDatabaseRoutingProcedureRunner runner = this.singleDatabaseRoutingProcedureRunner(RoutingContext.EMPTY);
        RuntimeException releaseError = new RuntimeException("Release failed");
        Connection connection = AbstractRoutingProcedureRunnerTest.connection(Futures.failedFuture((Throwable)releaseError));
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            RoutingProcedureResponse cfr_ignored_0 = (RoutingProcedureResponse)TestUtil.await(runner.run(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
        });
        Assertions.assertEquals((Object)releaseError, (Object)e);
        ((Connection)Mockito.verify((Object)connection)).release();
    }

    abstract SingleDatabaseRoutingProcedureRunner singleDatabaseRoutingProcedureRunner(RoutingContext var1);

    abstract SingleDatabaseRoutingProcedureRunner singleDatabaseRoutingProcedureRunner(RoutingContext var1, CompletionStage<List<Record>> var2);

    static Connection connection() {
        return AbstractRoutingProcedureRunnerTest.connection(Futures.completedWithNull());
    }

    static Connection connection(CompletionStage<Void> releaseStage) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.release()).thenReturn(releaseStage);
        return connection;
    }
}

