/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.value.StringValue;

class RoutingProcedureResponseTest {
    private static final Query PROCEDURE = new Query("procedure");
    private static final Record RECORD_1 = new InternalRecord(Arrays.asList("a", "b"), new Value[]{new StringValue("a"), new StringValue("b")});
    private static final Record RECORD_2 = new InternalRecord(Arrays.asList("a", "b"), new Value[]{new StringValue("aa"), new StringValue("bb")});

    RoutingProcedureResponseTest() {
    }

    @Test
    void shouldBeSuccessfulWithRecords() {
        RoutingProcedureResponse response = new RoutingProcedureResponse(PROCEDURE, Arrays.asList(RECORD_1, RECORD_2));
        Assertions.assertTrue((boolean)response.isSuccess());
    }

    @Test
    void shouldNotBeSuccessfulWithError() {
        RoutingProcedureResponse response = new RoutingProcedureResponse(PROCEDURE, (Throwable)new RuntimeException());
        Assertions.assertFalse((boolean)response.isSuccess());
    }

    @Test
    void shouldThrowWhenFailedAndAskedForRecords() {
        RuntimeException error = new RuntimeException();
        RoutingProcedureResponse response = new RoutingProcedureResponse(PROCEDURE, (Throwable)error);
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((RoutingProcedureResponse)response).records());
        Assertions.assertEquals((Object)e.getCause(), (Object)error);
    }

    @Test
    void shouldThrowWhenSuccessfulAndAskedForError() {
        RoutingProcedureResponse response = new RoutingProcedureResponse(PROCEDURE, Arrays.asList(RECORD_1, RECORD_2));
        Assertions.assertThrows(IllegalStateException.class, () -> ((RoutingProcedureResponse)response).error());
    }

    @Test
    void shouldHaveErrorWhenFailed() {
        RuntimeException error = new RuntimeException("Hi!");
        RoutingProcedureResponse response = new RoutingProcedureResponse(PROCEDURE, (Throwable)error);
        Assertions.assertEquals((Object)error, (Object)response.error());
    }

    @Test
    void shouldHaveRecordsWhenSuccessful() {
        RoutingProcedureResponse response = new RoutingProcedureResponse(PROCEDURE, Arrays.asList(RECORD_1, RECORD_2));
        Assertions.assertEquals(Arrays.asList(RECORD_1, RECORD_2), (Object)response.records());
    }

    @Test
    void shouldHaveProcedure() {
        RoutingProcedureResponse response = new RoutingProcedureResponse(PROCEDURE, Arrays.asList(RECORD_1, RECORD_2));
        Assertions.assertEquals((Object)PROCEDURE, (Object)response.procedure());
    }
}

