/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster.loadbalancing;

import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.ImmutableConnectionContext;
import org.neo4j.driver.internal.async.connection.RoutingConnection;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RediscoveryUtil;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancer;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.v42.BoltProtocolV42;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.ClusterCompositionUtil;
import org.neo4j.driver.internal.util.FakeClock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.net.ServerAddress;
import org.neo4j.driver.util.TestUtil;

class LoadBalancerTest {
    LoadBalancerTest() {
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void returnsCorrectAccessMode(AccessMode mode) {
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMock();
        RoutingTable routingTable = (RoutingTable)Mockito.mock(RoutingTable.class);
        List<BoltServerAddress> readerAddresses = Collections.singletonList(ClusterCompositionUtil.A);
        List<BoltServerAddress> writerAddresses = Collections.singletonList(ClusterCompositionUtil.B);
        Mockito.when((Object)routingTable.readers()).thenReturn(readerAddresses);
        Mockito.when((Object)routingTable.writers()).thenReturn(writerAddresses);
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, routingTable);
        Connection acquired = (Connection)TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithMode(mode)));
        MatcherAssert.assertThat((Object)acquired, (Matcher)Matchers.instanceOf(RoutingConnection.class));
        MatcherAssert.assertThat((Object)acquired.mode(), (Matcher)Matchers.equalTo((Object)mode));
    }

    @ParameterizedTest
    @ValueSource(strings={"", "foo", "data"})
    void returnsCorrectDatabaseName(String databaseName) {
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMock();
        RoutingTable routingTable = (RoutingTable)Mockito.mock(RoutingTable.class);
        List<BoltServerAddress> writerAddresses = Collections.singletonList(ClusterCompositionUtil.A);
        Mockito.when((Object)routingTable.writers()).thenReturn(writerAddresses);
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, routingTable);
        Connection acquired = (Connection)TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithDatabase(databaseName)));
        MatcherAssert.assertThat((Object)acquired, (Matcher)Matchers.instanceOf(RoutingConnection.class));
        MatcherAssert.assertThat((Object)acquired.databaseName().description(), (Matcher)Matchers.equalTo((Object)databaseName));
        ((ConnectionPool)Mockito.verify((Object)connectionPool)).acquire(ClusterCompositionUtil.A);
    }

    @Test
    void shouldThrowWhenRediscoveryReturnsNoSuitableServers() {
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMock();
        RoutingTable routingTable = (RoutingTable)Mockito.mock(RoutingTable.class);
        Mockito.when((Object)routingTable.readers()).thenReturn(Collections.emptyList());
        Mockito.when((Object)routingTable.writers()).thenReturn(Collections.emptyList());
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, routingTable);
        SessionExpiredException error1 = (SessionExpiredException)Assertions.assertThrows(SessionExpiredException.class, () -> {
            Connection cfr_ignored_0 = (Connection)TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithMode(AccessMode.READ)));
        });
        MatcherAssert.assertThat((Object)error1.getMessage(), (Matcher)Matchers.startsWith((String)"Failed to obtain connection towards READ server"));
        SessionExpiredException error2 = (SessionExpiredException)Assertions.assertThrows(SessionExpiredException.class, () -> {
            Connection cfr_ignored_0 = (Connection)TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithMode(AccessMode.WRITE)));
        });
        MatcherAssert.assertThat((Object)error2.getMessage(), (Matcher)Matchers.startsWith((String)"Failed to obtain connection towards WRITE server"));
    }

    @Test
    void shouldSelectLeastConnectedAddress() {
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMock();
        Mockito.when((Object)connectionPool.inUseConnections((ServerAddress)ClusterCompositionUtil.A)).thenReturn((Object)0);
        Mockito.when((Object)connectionPool.inUseConnections((ServerAddress)ClusterCompositionUtil.B)).thenReturn((Object)20);
        Mockito.when((Object)connectionPool.inUseConnections((ServerAddress)ClusterCompositionUtil.C)).thenReturn((Object)0);
        RoutingTable routingTable = (RoutingTable)Mockito.mock(RoutingTable.class);
        List<BoltServerAddress> readerAddresses = Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        Mockito.when((Object)routingTable.readers()).thenReturn(readerAddresses);
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, routingTable);
        HashSet<BoltServerAddress> seenAddresses = new HashSet<BoltServerAddress>();
        for (int i = 0; i < 10; ++i) {
            Connection connection = (Connection)TestUtil.await(loadBalancer.acquireConnection(LoadBalancerTest.newBoltV4ConnectionContext()));
            seenAddresses.add(connection.serverAddress());
        }
        Assertions.assertEquals((int)2, (int)seenAddresses.size());
        Assertions.assertTrue((boolean)seenAddresses.containsAll(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.C)));
    }

    @Test
    void shouldRoundRobinWhenNoActiveConnections() {
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMock();
        RoutingTable routingTable = (RoutingTable)Mockito.mock(RoutingTable.class);
        List<BoltServerAddress> readerAddresses = Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        Mockito.when((Object)routingTable.readers()).thenReturn(readerAddresses);
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, routingTable);
        HashSet<BoltServerAddress> seenAddresses = new HashSet<BoltServerAddress>();
        for (int i = 0; i < 10; ++i) {
            Connection connection = (Connection)TestUtil.await(loadBalancer.acquireConnection(LoadBalancerTest.newBoltV4ConnectionContext()));
            seenAddresses.add(connection.serverAddress());
        }
        Assertions.assertEquals((int)3, (int)seenAddresses.size());
        Assertions.assertTrue((boolean)seenAddresses.containsAll(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C)));
    }

    @Test
    void shouldTryMultipleServersAfterRediscovery() {
        Set<BoltServerAddress> unavailableAddresses = TestUtil.asOrderedSet(ClusterCompositionUtil.A);
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMockWithFailures(unavailableAddresses);
        ClusterRoutingTable routingTable = new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), (Clock)new FakeClock(), new BoltServerAddress[0]);
        routingTable.update(new ClusterComposition(-1L, new LinkedHashSet<BoltServerAddress>(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B)), Collections.emptySet(), Collections.emptySet(), null));
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, (RoutingTable)routingTable);
        Connection connection = (Connection)TestUtil.await(loadBalancer.acquireConnection(LoadBalancerTest.newBoltV4ConnectionContext()));
        Assertions.assertNotNull((Object)connection);
        Assertions.assertEquals((Object)ClusterCompositionUtil.B, (Object)connection.serverAddress());
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{ClusterCompositionUtil.B}, (Object[])routingTable.readers().toArray());
    }

    @Test
    void shouldFailWithResolverError() throws Throwable {
        ConnectionPool pool = (ConnectionPool)Mockito.mock(ConnectionPool.class);
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.resolve()).thenThrow(new Throwable[]{new RuntimeException("hi there")});
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(pool, rediscovery);
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)TestUtil.await(loadBalancer.supportsMultiDb());
        });
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"hi there"));
    }

    @Test
    void shouldFailAfterTryingAllServers() throws Throwable {
        Set<BoltServerAddress> unavailableAddresses = TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B);
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMockWithFailures(unavailableAddresses);
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.resolve()).thenReturn(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B));
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, rediscovery);
        ServiceUnavailableException exception = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)TestUtil.await(loadBalancer.supportsMultiDb());
        });
        Throwable[] suppressed = exception.getSuppressed();
        MatcherAssert.assertThat((Object)suppressed.length, (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)suppressed[0].getMessage(), (Matcher)Matchers.containsString((String)ClusterCompositionUtil.A.toString()));
        MatcherAssert.assertThat((Object)suppressed[1].getMessage(), (Matcher)Matchers.containsString((String)ClusterCompositionUtil.B.toString()));
        ((ConnectionPool)Mockito.verify((Object)connectionPool, (VerificationMode)Mockito.times((int)2))).acquire((BoltServerAddress)ArgumentMatchers.any());
    }

    @Test
    void shouldFailEarlyOnSecurityError() throws Throwable {
        Set<BoltServerAddress> unavailableAddresses = TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B);
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMockWithFailures(unavailableAddresses, address -> new SecurityException("code", "hi there"));
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.resolve()).thenReturn(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B));
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, rediscovery);
        SecurityException exception = (SecurityException)Assertions.assertThrows(SecurityException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)TestUtil.await(loadBalancer.supportsMultiDb());
        });
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.startsWith((String)"hi there"));
        ((ConnectionPool)Mockito.verify((Object)connectionPool, (VerificationMode)Mockito.times((int)1))).acquire((BoltServerAddress)ArgumentMatchers.any());
    }

    @Test
    void shouldSuccessOnFirstSuccessfulServer() throws Throwable {
        Set<BoltServerAddress> unavailableAddresses = TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B);
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMockWithFailures(unavailableAddresses);
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.resolve()).thenReturn(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C, ClusterCompositionUtil.D));
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, rediscovery);
        Assertions.assertTrue((boolean)((Boolean)TestUtil.await(loadBalancer.supportsMultiDb())));
        ((ConnectionPool)Mockito.verify((Object)connectionPool, (VerificationMode)Mockito.times((int)3))).acquire((BoltServerAddress)ArgumentMatchers.any());
    }

    @Test
    void shouldThrowModifiedErrorWhenSupportMultiDbTestFails() throws Throwable {
        Set<BoltServerAddress> unavailableAddresses = TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B);
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMockWithFailures(unavailableAddresses);
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.resolve()).thenReturn(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B));
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, rediscovery);
        ServiceUnavailableException exception = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(loadBalancer.verifyConnectivity());
        });
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.startsWith((String)"Unable to connect to database management service,"));
    }

    @Test
    void shouldFailEarlyOnSecurityErrorWhenSupportMultiDbTestFails() throws Throwable {
        Set<BoltServerAddress> unavailableAddresses = TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B);
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMockWithFailures(unavailableAddresses, address -> new AuthenticationException("code", "error"));
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.resolve()).thenReturn(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B));
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, rediscovery);
        AuthenticationException exception = (AuthenticationException)Assertions.assertThrows(AuthenticationException.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(loadBalancer.verifyConnectivity());
        });
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.startsWith((String)"error"));
    }

    @Test
    void shouldThrowModifiedErrorWhenRefreshRoutingTableFails() throws Throwable {
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMock();
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.resolve()).thenReturn(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B));
        RoutingTableRegistry routingTables = (RoutingTableRegistry)Mockito.mock(RoutingTableRegistry.class);
        Mockito.when((Object)routingTables.ensureRoutingTable((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class))).thenThrow(new Throwable[]{new ServiceUnavailableException("boooo")});
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, routingTables, rediscovery);
        ServiceUnavailableException exception = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(loadBalancer.verifyConnectivity());
        });
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.startsWith((String)"Unable to connect to database management service,"));
        ((RoutingTableRegistry)Mockito.verify((Object)routingTables)).ensureRoutingTable((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class));
    }

    @Test
    void shouldThrowOriginalErrorWhenRefreshRoutingTableFails() throws Throwable {
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMock();
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.resolve()).thenReturn(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B));
        RoutingTableRegistry routingTables = (RoutingTableRegistry)Mockito.mock(RoutingTableRegistry.class);
        Mockito.when((Object)routingTables.ensureRoutingTable((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class))).thenThrow(new Throwable[]{new RuntimeException("boo")});
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, routingTables, rediscovery);
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(loadBalancer.verifyConnectivity());
        });
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.startsWith((String)"boo"));
        ((RoutingTableRegistry)Mockito.verify((Object)routingTables)).ensureRoutingTable((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class));
    }

    @Test
    void shouldReturnSuccessVerifyConnectivity() throws Throwable {
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMock();
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.resolve()).thenReturn(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B));
        RoutingTableRegistry routingTables = (RoutingTableRegistry)Mockito.mock(RoutingTableRegistry.class);
        Mockito.when((Object)routingTables.ensureRoutingTable((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class))).thenReturn((Object)Futures.completedWithNull());
        LoadBalancer loadBalancer = LoadBalancerTest.newLoadBalancer(connectionPool, routingTables, rediscovery);
        TestUtil.await(loadBalancer.verifyConnectivity());
        ((RoutingTableRegistry)Mockito.verify((Object)routingTables)).ensureRoutingTable((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void expectsCompetedDatabaseNameAfterRoutingTableRegistry(boolean completed) throws Throwable {
        ConnectionPool connectionPool = LoadBalancerTest.newConnectionPoolMock();
        RoutingTable routingTable = (RoutingTable)Mockito.mock(RoutingTable.class);
        List<BoltServerAddress> readerAddresses = Collections.singletonList(ClusterCompositionUtil.A);
        List<BoltServerAddress> writerAddresses = Collections.singletonList(ClusterCompositionUtil.B);
        Mockito.when((Object)routingTable.readers()).thenReturn(readerAddresses);
        Mockito.when((Object)routingTable.writers()).thenReturn(writerAddresses);
        RoutingTableRegistry routingTables = (RoutingTableRegistry)Mockito.mock(RoutingTableRegistry.class);
        RoutingTableHandler handler = (RoutingTableHandler)Mockito.mock(RoutingTableHandler.class);
        Mockito.when((Object)handler.routingTable()).thenReturn((Object)routingTable);
        Mockito.when((Object)routingTables.ensureRoutingTable((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class))).thenReturn(CompletableFuture.completedFuture(handler));
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        LoadBalancer loadBalancer = new LoadBalancer(connectionPool, routingTables, rediscovery, (LoadBalancingStrategy)new LeastConnectedLoadBalancingStrategy(connectionPool, DevNullLogging.DEV_NULL_LOGGING), (EventExecutorGroup)GlobalEventExecutor.INSTANCE, DevNullLogging.DEV_NULL_LOGGING);
        ConnectionContext context = (ConnectionContext)Mockito.mock(ConnectionContext.class);
        CompletableFuture databaseNameFuture = (CompletableFuture)Mockito.spy(new CompletableFuture());
        if (completed) {
            databaseNameFuture.complete(DatabaseNameUtil.systemDatabase());
        }
        Mockito.when((Object)context.databaseNameFuture()).thenReturn((Object)databaseNameFuture);
        Mockito.when((Object)context.mode()).thenReturn((Object)AccessMode.WRITE);
        Executable action = () -> {
            Connection cfr_ignored_0 = (Connection)TestUtil.await(loadBalancer.acquireConnection(context));
        };
        if (completed) {
            action.execute();
        } else {
            Assertions.assertThrows(IllegalStateException.class, (Executable)action, (String)((IllegalStateException)ConnectionContext.PENDING_DATABASE_NAME_EXCEPTION_SUPPLIER.get()).getMessage());
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{routingTables, context, databaseNameFuture});
        ((RoutingTableRegistry)inOrder.verify((Object)routingTables)).ensureRoutingTable(context);
        ((ConnectionContext)inOrder.verify((Object)context)).databaseNameFuture();
        ((CompletableFuture)inOrder.verify((Object)databaseNameFuture)).isDone();
        if (completed) {
            ((CompletableFuture)inOrder.verify((Object)databaseNameFuture)).join();
        }
    }

    private static ConnectionPool newConnectionPoolMock() {
        return LoadBalancerTest.newConnectionPoolMockWithFailures(Collections.emptySet());
    }

    private static ConnectionPool newConnectionPoolMockWithFailures(Set<BoltServerAddress> unavailableAddresses) {
        return LoadBalancerTest.newConnectionPoolMockWithFailures(unavailableAddresses, address -> new ServiceUnavailableException(address + " is unavailable!"));
    }

    private static ConnectionPool newConnectionPoolMockWithFailures(Set<BoltServerAddress> unavailableAddresses, Function<BoltServerAddress, Throwable> errorAction) {
        ConnectionPool pool = (ConnectionPool)Mockito.mock(ConnectionPool.class);
        Mockito.when((Object)pool.acquire((BoltServerAddress)ArgumentMatchers.any(BoltServerAddress.class))).then(invocation -> {
            BoltServerAddress requestedAddress = (BoltServerAddress)invocation.getArgument(0);
            if (unavailableAddresses.contains(requestedAddress)) {
                return Futures.failedFuture((Throwable)((Throwable)errorAction.apply(requestedAddress)));
            }
            return CompletableFuture.completedFuture(LoadBalancerTest.newBoltV4Connection(requestedAddress));
        });
        return pool;
    }

    private static Connection newBoltV4Connection(BoltServerAddress address) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.serverAddress()).thenReturn((Object)address);
        Mockito.when((Object)connection.protocol()).thenReturn((Object)BoltProtocol.forVersion((BoltProtocolVersion)BoltProtocolV42.VERSION));
        Mockito.when((Object)connection.serverVersion()).thenReturn((Object)ServerVersion.v4_1_0);
        Mockito.when((Object)connection.release()).thenReturn((Object)Futures.completedWithNull());
        return connection;
    }

    private static ConnectionContext newBoltV4ConnectionContext() {
        return ImmutableConnectionContext.simple((boolean)true);
    }

    private static LoadBalancer newLoadBalancer(ConnectionPool connectionPool, RoutingTable routingTable) {
        RoutingTableRegistry routingTables = (RoutingTableRegistry)Mockito.mock(RoutingTableRegistry.class);
        RoutingTableHandler handler = (RoutingTableHandler)Mockito.mock(RoutingTableHandler.class);
        Mockito.when((Object)handler.routingTable()).thenReturn((Object)routingTable);
        Mockito.when((Object)routingTables.ensureRoutingTable((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class))).thenReturn(CompletableFuture.completedFuture(handler));
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        return new LoadBalancer(connectionPool, routingTables, rediscovery, (LoadBalancingStrategy)new LeastConnectedLoadBalancingStrategy(connectionPool, DevNullLogging.DEV_NULL_LOGGING), (EventExecutorGroup)GlobalEventExecutor.INSTANCE, DevNullLogging.DEV_NULL_LOGGING);
    }

    private static LoadBalancer newLoadBalancer(ConnectionPool connectionPool, Rediscovery rediscovery) {
        RoutingTableRegistry routingTables = (RoutingTableRegistry)Mockito.mock(RoutingTableRegistry.class);
        return LoadBalancerTest.newLoadBalancer(connectionPool, routingTables, rediscovery);
    }

    private static LoadBalancer newLoadBalancer(ConnectionPool connectionPool, RoutingTableRegistry routingTables, Rediscovery rediscovery) {
        return new LoadBalancer(connectionPool, routingTables, rediscovery, (LoadBalancingStrategy)new LeastConnectedLoadBalancingStrategy(connectionPool, DevNullLogging.DEV_NULL_LOGGING), (EventExecutorGroup)GlobalEventExecutor.INSTANCE, DevNullLogging.DEV_NULL_LOGGING);
    }
}

