/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster.loadbalancing;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.cluster.loadbalancing.RoundRobinArrayIndex;

class RoundRobinArrayIndexTest {
    RoundRobinArrayIndexTest() {
    }

    @Test
    void shouldHandleZeroLength() {
        RoundRobinArrayIndex roundRobinIndex = new RoundRobinArrayIndex();
        int index = roundRobinIndex.next(0);
        Assertions.assertEquals((int)-1, (int)index);
    }

    @Test
    void shouldReturnIndexesInRoundRobinOrder() {
        int index;
        int i;
        RoundRobinArrayIndex roundRobinIndex = new RoundRobinArrayIndex();
        for (i = 0; i < 10; ++i) {
            index = roundRobinIndex.next(10);
            Assertions.assertEquals((int)i, (int)index);
        }
        for (i = 0; i < 5; ++i) {
            index = roundRobinIndex.next(5);
            Assertions.assertEquals((int)i, (int)index);
        }
    }

    @Test
    void shouldHandleOverflow() {
        int arrayLength = 10;
        RoundRobinArrayIndex roundRobinIndex = new RoundRobinArrayIndex(0x7FFFFFFE);
        Assertions.assertEquals((int)(0x7FFFFFFE % arrayLength), (int)roundRobinIndex.next(arrayLength));
        Assertions.assertEquals((int)(Integer.MAX_VALUE % arrayLength), (int)roundRobinIndex.next(arrayLength));
        Assertions.assertEquals((int)0, (int)roundRobinIndex.next(arrayLength));
        Assertions.assertEquals((int)1, (int)roundRobinIndex.next(arrayLength));
        Assertions.assertEquals((int)2, (int)roundRobinIndex.next(arrayLength));
    }
}

