/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.DisposableAsyncResultCursor;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.util.TestUtil;

class DisposableAsyncResultCursorTest {
    DisposableAsyncResultCursor cursor;
    AsyncResultCursor delegate;

    DisposableAsyncResultCursorTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.delegate = (AsyncResultCursor)Mockito.mock(AsyncResultCursor.class);
        Mockito.when((Object)this.delegate.consumeAsync()).thenReturn((Object)Futures.completedWithNull());
        Mockito.when((Object)this.delegate.discardAllFailureAsync()).thenReturn((Object)Futures.completedWithNull());
        Mockito.when((Object)this.delegate.peekAsync()).thenReturn((Object)Futures.completedWithNull());
        Mockito.when((Object)this.delegate.nextAsync()).thenReturn((Object)Futures.completedWithNull());
        Mockito.when((Object)this.delegate.singleAsync()).thenReturn((Object)Futures.completedWithNull());
        Mockito.when((Object)this.delegate.forEachAsync((Consumer)ArgumentMatchers.any())).thenReturn((Object)Futures.completedWithNull());
        Mockito.when((Object)this.delegate.listAsync()).thenReturn((Object)Futures.completedWithNull());
        Mockito.when((Object)this.delegate.listAsync((Function)ArgumentMatchers.any())).thenReturn((Object)Futures.completedWithNull());
        Mockito.when((Object)this.delegate.pullAllFailureAsync()).thenReturn((Object)Futures.completedWithNull());
        Mockito.when((Object)this.delegate.mapSuccessfulRunCompletionAsync()).thenReturn(CompletableFuture.completedFuture(this.delegate));
        this.cursor = new DisposableAsyncResultCursor(this.delegate);
    }

    @Test
    void summaryShouldDisposeCursor() {
        TestUtil.await(this.cursor.consumeAsync());
        Assertions.assertTrue((boolean)this.cursor.isDisposed());
    }

    @Test
    void consumeShouldDisposeCursor() {
        TestUtil.await(this.cursor.discardAllFailureAsync());
        Assertions.assertTrue((boolean)this.cursor.isDisposed());
    }

    @Test
    void shouldNotDisposeCursor() {
        this.cursor.keys();
        TestUtil.await(this.cursor.peekAsync());
        TestUtil.await(this.cursor.nextAsync());
        TestUtil.await(this.cursor.singleAsync());
        TestUtil.await(this.cursor.forEachAsync(record -> {}));
        TestUtil.await(this.cursor.listAsync());
        TestUtil.await(this.cursor.listAsync(record -> record));
        TestUtil.await(this.cursor.pullAllFailureAsync());
        Assertions.assertFalse((boolean)this.cursor.isDisposed());
    }

    @Test
    void shouldReturnItselfOnMapSuccessfulRunCompletionAsync() {
        AsyncResultCursor actual = (AsyncResultCursor)TestUtil.await(this.cursor.mapSuccessfulRunCompletionAsync());
        ((AsyncResultCursor)BDDMockito.then((Object)this.delegate).should()).mapSuccessfulRunCompletionAsync();
        Assertions.assertSame((Object)this.cursor, (Object)actual);
    }

    @Test
    void shouldFailOnMapSuccessfulRunCompletionAsyncFailure() {
        Throwable error = (Throwable)Mockito.mock(Throwable.class);
        BDDMockito.given((Object)this.delegate.mapSuccessfulRunCompletionAsync()).willReturn((Object)Futures.failedFuture((Throwable)error));
        Throwable actual = Assertions.assertThrows(Throwable.class, () -> {
            AsyncResultCursor cfr_ignored_0 = (AsyncResultCursor)TestUtil.await(this.cursor.mapSuccessfulRunCompletionAsync());
        });
        ((AsyncResultCursor)BDDMockito.then((Object)this.delegate).should()).mapSuccessfulRunCompletionAsync();
        Assertions.assertSame((Object)error, (Object)actual);
    }
}

