/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.ResultCursorFactoryImpl;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursorImpl;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.util.TestUtil;

class ResultCursorFactoryImplTest {
    ResultCursorFactoryImplTest() {
    }

    @Test
    void shouldReturnAsyncResultWhenRunSucceeded() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        ResultCursorFactoryImpl cursorFactory = this.newResultCursorFactory(connection, null);
        CompletionStage cursorFuture = cursorFactory.asyncResult();
        this.verifyRunCompleted(connection, cursorFuture);
    }

    @Test
    void shouldReturnAsyncResultWithRunErrorWhenRunFailed() {
        RuntimeException error = new RuntimeException("Hi there");
        ResultCursorFactoryImpl cursorFactory = this.newResultCursorFactory(error);
        CompletionStage cursorFuture = cursorFactory.asyncResult();
        AsyncResultCursor cursor = (AsyncResultCursor)Futures.getNow((CompletionStage)cursorFuture);
        Throwable actual = Assertions.assertThrows(error.getClass(), () -> {
            AsyncResultCursor cfr_ignored_0 = (AsyncResultCursor)TestUtil.await(cursor.mapSuccessfulRunCompletionAsync());
        });
        Assertions.assertSame((Object)error, (Object)actual);
    }

    @Test
    void shouldPrePopulateRecords() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Message runMessage = (Message)Mockito.mock(Message.class);
        RunResponseHandler runHandler = (RunResponseHandler)Mockito.mock(RunResponseHandler.class);
        CompletableFuture runFuture = new CompletableFuture();
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        ResultCursorFactoryImpl cursorFactory = new ResultCursorFactoryImpl(connection, runMessage, runHandler, runFuture, pullHandler, pullAllHandler);
        cursorFactory.asyncResult();
        ((PullAllResponseHandler)Mockito.verify((Object)pullAllHandler)).prePopulateRecords();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pullHandler});
    }

    @Test
    void shouldReturnRxResultWhenRunSucceeded() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        ResultCursorFactoryImpl cursorFactory = this.newResultCursorFactory(connection, null);
        CompletionStage cursorFuture = cursorFactory.rxResult();
        this.verifyRxRunCompleted(connection, cursorFuture);
    }

    @Test
    void shouldReturnRxResultWhenRunFailed() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RuntimeException error = new RuntimeException("Hi there");
        ResultCursorFactoryImpl cursorFactory = this.newResultCursorFactory(connection, error);
        CompletionStage cursorFuture = cursorFactory.rxResult();
        this.verifyRxRunCompleted(connection, cursorFuture);
    }

    private ResultCursorFactoryImpl newResultCursorFactory(Connection connection, Throwable runError) {
        Message runMessage = (Message)Mockito.mock(Message.class);
        RunResponseHandler runHandler = (RunResponseHandler)Mockito.mock(RunResponseHandler.class);
        CompletableFuture runFuture = new CompletableFuture();
        if (runError != null) {
            runFuture.completeExceptionally(runError);
        } else {
            runFuture.complete(null);
        }
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        return new ResultCursorFactoryImpl(connection, runMessage, runHandler, runFuture, pullHandler, pullAllHandler);
    }

    private ResultCursorFactoryImpl newResultCursorFactory(Throwable runError) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        return this.newResultCursorFactory(connection, runError);
    }

    private void verifyRunCompleted(Connection connection, CompletionStage<AsyncResultCursor> cursorFuture) {
        ((Connection)Mockito.verify((Object)connection)).write((Message)ArgumentMatchers.any(Message.class), (ResponseHandler)ArgumentMatchers.any(RunResponseHandler.class));
        Assert.assertThat((Object)Futures.getNow(cursorFuture), (Matcher)CoreMatchers.instanceOf(AsyncResultCursor.class));
    }

    private void verifyRxRunCompleted(Connection connection, CompletionStage<RxResultCursor> cursorFuture) {
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(Message.class), (ResponseHandler)ArgumentMatchers.any(RunResponseHandler.class));
        Assert.assertThat((Object)Futures.getNow(cursorFuture), (Matcher)CoreMatchers.instanceOf(RxResultCursorImpl.class));
    }
}

