/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import junit.framework.TestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ResultConsumedException;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursorImpl;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.reactive.util.ListBasedPullHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.summary.ResultSummary;

class RxResultCursorImplTest {
    RxResultCursorImplTest() {
    }

    @Test
    void shouldInstallSummaryConsumerWithoutReportingError() {
        RuntimeException error = new RuntimeException("Hi");
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler(error);
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        new RxResultCursorImpl((Throwable)error, runHandler, pullHandler);
        ((PullResponseHandler)Mockito.verify((Object)pullHandler)).installSummaryConsumer((BiConsumer)ArgumentMatchers.any(BiConsumer.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pullHandler});
    }

    @Test
    void shouldReturnQueryKeys() {
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler();
        List<String> expected = Arrays.asList("key1", "key2", "key3");
        runHandler.onSuccess(Collections.singletonMap("fields", Values.value(expected)));
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, pullHandler);
        List actual = cursor.keys();
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    void shouldSupportReturnQueryKeysMultipleTimes() {
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler();
        List<String> expected = Arrays.asList("key1", "key2", "key3");
        runHandler.onSuccess(Collections.singletonMap("fields", Values.value(expected)));
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, pullHandler);
        List actual = cursor.keys();
        Assertions.assertEquals(expected, (Object)actual);
        actual = cursor.keys();
        Assertions.assertEquals(expected, (Object)actual);
        actual = cursor.keys();
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    void shouldPull() {
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler();
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, pullHandler);
        cursor.request(100L);
        ((PullResponseHandler)Mockito.verify((Object)pullHandler)).request(100L);
    }

    @Test
    void shouldPullUnboundedOnLongMax() {
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler();
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, pullHandler);
        cursor.request(Long.MAX_VALUE);
        ((PullResponseHandler)Mockito.verify((Object)pullHandler)).request(-1L);
    }

    @Test
    void shouldCancel() {
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler();
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, pullHandler);
        cursor.cancel();
        ((PullResponseHandler)Mockito.verify((Object)pullHandler)).cancel();
    }

    @Test
    void shouldInstallRecordConsumerAndReportError() {
        RuntimeException error = new RuntimeException("Hi");
        BiConsumer recordConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler(error);
        ListBasedPullHandler pullHandler = new ListBasedPullHandler();
        RxResultCursorImpl cursor = new RxResultCursorImpl((Throwable)error, runHandler, (PullResponseHandler)pullHandler);
        cursor.installRecordConsumer(recordConsumer);
        ((BiConsumer)Mockito.verify((Object)recordConsumer)).accept(null, error);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{recordConsumer});
    }

    @Test
    void shouldReturnSummaryFuture() {
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler();
        ListBasedPullHandler pullHandler = new ListBasedPullHandler();
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, (PullResponseHandler)pullHandler);
        cursor.installRecordConsumer(RxResultCursorImpl.DISCARD_RECORD_CONSUMER);
        cursor.request(10L);
        cursor.summaryAsync();
        TestCase.assertTrue((boolean)cursor.isDone());
    }

    @Test
    void shouldNotAllowToInstallRecordConsumerAfterSummary() {
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler();
        ListBasedPullHandler pullHandler = new ListBasedPullHandler();
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, (PullResponseHandler)pullHandler);
        cursor.summaryAsync();
        Assertions.assertThrows(ResultConsumedException.class, () -> RxResultCursorImplTest.lambda$shouldNotAllowToInstallRecordConsumerAfterSummary$0((RxResultCursor)cursor));
    }

    @Test
    void shouldAllowToCallSummaryMultipleTimes() {
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler();
        ListBasedPullHandler pullHandler = new ListBasedPullHandler();
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, (PullResponseHandler)pullHandler);
        cursor.summaryAsync();
        cursor.summaryAsync();
        cursor.summaryAsync();
    }

    @Test
    void shouldOnlyInstallRecordConsumerOnce() {
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler();
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, pullHandler);
        cursor.installRecordConsumer(RxResultCursorImpl.DISCARD_RECORD_CONSUMER);
        cursor.installRecordConsumer(RxResultCursorImpl.DISCARD_RECORD_CONSUMER);
        ((PullResponseHandler)Mockito.verify((Object)pullHandler)).installRecordConsumer((BiConsumer)ArgumentMatchers.any());
    }

    @Test
    void shouldCancelIfNotPulled() {
        RunResponseHandler runHandler = RxResultCursorImplTest.newRunResponseHandler();
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, pullHandler);
        cursor.summaryAsync();
        ((PullResponseHandler)Mockito.verify((Object)pullHandler)).installRecordConsumer(RxResultCursorImpl.DISCARD_RECORD_CONSUMER);
        ((PullResponseHandler)Mockito.verify((Object)pullHandler)).cancel();
        Assertions.assertFalse((boolean)cursor.isDone());
    }

    @Test
    void shouldPropagateSummaryErrorViaSummaryStageWhenItIsRetrievedExternally() throws ExecutionException, InterruptedException {
        RunResponseHandler runHandler = (RunResponseHandler)Mockito.mock(RunResponseHandler.class);
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        ArgumentCaptor summaryConsumerCaptor = ArgumentCaptor.forClass(BiConsumer.class);
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, pullHandler);
        ((PullResponseHandler)Mockito.verify((Object)pullHandler, (VerificationMode)Mockito.times((int)1))).installSummaryConsumer((BiConsumer)summaryConsumerCaptor.capture());
        BiConsumer summaryConsumer = (BiConsumer)summaryConsumerCaptor.getValue();
        RuntimeException exception = (RuntimeException)Mockito.mock(RuntimeException.class);
        CompletionStage summaryStage = cursor.summaryAsync();
        CompletionStage discardStage = cursor.discardAllFailureAsync();
        summaryConsumer.accept(null, exception);
        ((PullResponseHandler)Mockito.verify((Object)pullHandler)).installRecordConsumer(RxResultCursorImpl.DISCARD_RECORD_CONSUMER);
        ((PullResponseHandler)Mockito.verify((Object)pullHandler)).cancel();
        ExecutionException actualException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            ResultSummary cfr_ignored_0 = (ResultSummary)summaryStage.toCompletableFuture().get();
        });
        Assertions.assertSame((Object)exception, (Object)actualException.getCause());
        Assertions.assertNull(discardStage.toCompletableFuture().get());
    }

    @Test
    void shouldPropagateSummaryErrorViaDiscardStageWhenSummaryStageIsNotRetrievedExternally() throws ExecutionException, InterruptedException {
        RunResponseHandler runHandler = (RunResponseHandler)Mockito.mock(RunResponseHandler.class);
        PullResponseHandler pullHandler = (PullResponseHandler)Mockito.mock(PullResponseHandler.class);
        ArgumentCaptor summaryConsumerCaptor = ArgumentCaptor.forClass(BiConsumer.class);
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, pullHandler);
        ((PullResponseHandler)Mockito.verify((Object)pullHandler, (VerificationMode)Mockito.times((int)1))).installSummaryConsumer((BiConsumer)summaryConsumerCaptor.capture());
        BiConsumer summaryConsumer = (BiConsumer)summaryConsumerCaptor.getValue();
        RuntimeException exception = (RuntimeException)Mockito.mock(RuntimeException.class);
        CompletionStage discardStage = cursor.discardAllFailureAsync();
        summaryConsumer.accept(null, exception);
        ((PullResponseHandler)Mockito.verify((Object)pullHandler)).installRecordConsumer(RxResultCursorImpl.DISCARD_RECORD_CONSUMER);
        ((PullResponseHandler)Mockito.verify((Object)pullHandler)).cancel();
        Assertions.assertSame((Object)exception, (Object)((Throwable)discardStage.toCompletableFuture().get()).getCause());
    }

    private static RunResponseHandler newRunResponseHandler(CompletableFuture<Void> runFuture) {
        return new RunResponseHandler(runFuture, BoltProtocolV3.METADATA_EXTRACTOR, (Connection)Mockito.mock(Connection.class), null);
    }

    private static RunResponseHandler newRunResponseHandler(Throwable error) {
        return RxResultCursorImplTest.newRunResponseHandler(Futures.failedFuture((Throwable)error));
    }

    private static RunResponseHandler newRunResponseHandler() {
        return RxResultCursorImplTest.newRunResponseHandler(Futures.completedWithNull());
    }

    private static /* synthetic */ void lambda$shouldNotAllowToInstallRecordConsumerAfterSummary$0(RxResultCursor cursor) throws Throwable {
        cursor.installRecordConsumer(null);
    }
}

