/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.handlers.ChannelReleasingResetResponseHandler;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.FakeClock;
import org.neo4j.driver.internal.util.Futures;

class ChannelReleasingResetResponseHandlerTest {
    private final EmbeddedChannel channel = new EmbeddedChannel();
    private final InboundMessageDispatcher messageDispatcher = (InboundMessageDispatcher)Mockito.mock(InboundMessageDispatcher.class);

    ChannelReleasingResetResponseHandlerTest() {
    }

    @AfterEach
    void tearDown() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    void shouldReleaseChannelOnSuccess() {
        ExtendedChannelPool pool = ChannelReleasingResetResponseHandlerTest.newChannelPoolMock();
        FakeClock clock = new FakeClock();
        clock.progress(5L);
        CompletableFuture<Void> releaseFuture = new CompletableFuture<Void>();
        ChannelReleasingResetResponseHandler handler = this.newHandler(pool, clock, releaseFuture);
        handler.onSuccess(Collections.emptyMap());
        this.verifyLastUsedTimestamp(5);
        ((ExtendedChannelPool)Mockito.verify((Object)pool)).release((Channel)ArgumentMatchers.eq((Object)this.channel));
        Assertions.assertTrue((boolean)releaseFuture.isDone());
        Assertions.assertFalse((boolean)releaseFuture.isCompletedExceptionally());
    }

    @Test
    void shouldCloseAndReleaseChannelOnFailure() {
        ExtendedChannelPool pool = ChannelReleasingResetResponseHandlerTest.newChannelPoolMock();
        FakeClock clock = new FakeClock();
        clock.progress(100L);
        CompletableFuture<Void> releaseFuture = new CompletableFuture<Void>();
        ChannelReleasingResetResponseHandler handler = this.newHandler(pool, clock, releaseFuture);
        handler.onFailure((Throwable)new RuntimeException());
        Assertions.assertTrue((boolean)this.channel.closeFuture().isDone());
        ((ExtendedChannelPool)Mockito.verify((Object)pool)).release((Channel)ArgumentMatchers.eq((Object)this.channel));
        Assertions.assertTrue((boolean)releaseFuture.isDone());
        Assertions.assertFalse((boolean)releaseFuture.isCompletedExceptionally());
    }

    private void verifyLastUsedTimestamp(int expectedValue) {
        Assertions.assertEquals((int)expectedValue, (int)ChannelAttributes.lastUsedTimestamp((Channel)this.channel).intValue());
    }

    private ChannelReleasingResetResponseHandler newHandler(ExtendedChannelPool pool, Clock clock, CompletableFuture<Void> releaseFuture) {
        return new ChannelReleasingResetResponseHandler((Channel)this.channel, pool, this.messageDispatcher, clock, releaseFuture);
    }

    private static ExtendedChannelPool newChannelPoolMock() {
        ExtendedChannelPool pool = (ExtendedChannelPool)Mockito.mock(ExtendedChannelPool.class);
        Mockito.when((Object)pool.release((Channel)ArgumentMatchers.any())).thenReturn((Object)Futures.completedWithNull());
        return pool;
    }
}

