/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.handlers.CommitTxResponseHandler;
import org.neo4j.driver.util.TestUtil;

class CommitTxResponseHandlerTest {
    private final CompletableFuture<Bookmark> future = new CompletableFuture();
    private final CommitTxResponseHandler handler = new CommitTxResponseHandler(this.future);

    CommitTxResponseHandlerTest() {
    }

    @Test
    void shouldHandleSuccessWithoutBookmark() {
        this.handler.onSuccess(Collections.emptyMap());
        Assertions.assertNull(TestUtil.await(this.future));
    }

    @Test
    void shouldHandleSuccessWithBookmark() {
        String bookmarkString = "neo4j:bookmark:v1:tx12345";
        this.handler.onSuccess(Collections.singletonMap("bookmark", Values.value((String)bookmarkString)));
        Assertions.assertEquals((Object)InternalBookmark.parse((String)bookmarkString), TestUtil.await(this.future));
    }

    @Test
    void shouldHandleFailure() {
        RuntimeException error = new RuntimeException("Hello");
        this.handler.onFailure((Throwable)error);
        RuntimeException receivedError = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            Bookmark cfr_ignored_0 = (Bookmark)TestUtil.await(this.future);
        });
        Assertions.assertEquals((Object)error, (Object)receivedError);
    }

    @Test
    void shouldFailToHandleRecord() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.handler.onRecord(new Value[]{Values.value((int)42)}));
    }
}

