/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.handlers.LegacyPullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullAllResponseHandlerTestBase;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.util.TestUtil;

class LegacyPullAllResponseHandlerTest
extends PullAllResponseHandlerTestBase<LegacyPullAllResponseHandler> {
    LegacyPullAllResponseHandlerTest() {
    }

    @Test
    void shouldDisableAutoReadWhenTooManyRecordsArrive() {
        Connection connection = this.connectionMock();
        LegacyPullAllResponseHandler handler = (LegacyPullAllResponseHandler)this.newHandler(Arrays.asList("key1", "key2"), connection);
        for (int i = 0; i < LegacyPullAllResponseHandler.RECORD_BUFFER_HIGH_WATERMARK + 1; ++i) {
            handler.onRecord(Values.values((Object[])new Object[]{100, 200}));
        }
        ((Connection)Mockito.verify((Object)connection)).disableAutoRead();
    }

    @Test
    void shouldEnableAutoReadWhenRecordsRetrievedFromBuffer() {
        int i;
        Connection connection = this.connectionMock();
        List<String> keys = Arrays.asList("key1", "key2");
        LegacyPullAllResponseHandler handler = (LegacyPullAllResponseHandler)this.newHandler(keys, connection);
        for (i = 0; i < LegacyPullAllResponseHandler.RECORD_BUFFER_HIGH_WATERMARK + 1; ++i) {
            handler.onRecord(Values.values((Object[])new Object[]{100, 200}));
        }
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).enableAutoRead();
        ((Connection)Mockito.verify((Object)connection)).disableAutoRead();
        while (i-- > LegacyPullAllResponseHandler.RECORD_BUFFER_LOW_WATERMARK - 1) {
            Record record = (Record)TestUtil.await(handler.nextAsync());
            Assertions.assertNotNull((Object)record);
            Assertions.assertEquals(keys, (Object)record.keys());
            Assertions.assertEquals((int)100, (int)record.get("key1").asInt());
            Assertions.assertEquals((int)200, (int)record.get("key2").asInt());
        }
        ((Connection)Mockito.verify((Object)connection)).enableAutoRead();
    }

    @Test
    void shouldNotDisableAutoReadWhenSummaryRequested() {
        Connection connection = this.connectionMock();
        List<String> keys = Arrays.asList("key1", "key2");
        LegacyPullAllResponseHandler handler = (LegacyPullAllResponseHandler)this.newHandler(keys, connection);
        CompletableFuture summaryFuture = handler.consumeAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)summaryFuture.isDone());
        int recordCount = LegacyPullAllResponseHandler.RECORD_BUFFER_HIGH_WATERMARK + 10;
        for (int i = 0; i < recordCount; ++i) {
            handler.onRecord(Values.values((Object[])new Object[]{"a", "b"}));
        }
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).disableAutoRead();
        handler.onSuccess(Collections.emptyMap());
        Assertions.assertTrue((boolean)summaryFuture.isDone());
        ResultSummary summary = (ResultSummary)TestUtil.await(summaryFuture);
        Assertions.assertNotNull((Object)summary);
        Assertions.assertNull(TestUtil.await(handler.nextAsync()));
    }

    @Test
    void shouldNotDisableAutoReadWhenFailureRequested() {
        Connection connection = this.connectionMock();
        List<String> keys = Arrays.asList("key1", "key2");
        LegacyPullAllResponseHandler handler = (LegacyPullAllResponseHandler)this.newHandler(keys, connection);
        CompletableFuture failureFuture = handler.pullAllFailureAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)failureFuture.isDone());
        int recordCount = LegacyPullAllResponseHandler.RECORD_BUFFER_HIGH_WATERMARK + 5;
        for (int i = 0; i < recordCount; ++i) {
            handler.onRecord(Values.values((Object[])new Object[]{123, 456}));
        }
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).disableAutoRead();
        IllegalStateException error = new IllegalStateException("Wrong config");
        handler.onFailure((Throwable)error);
        Assertions.assertTrue((boolean)failureFuture.isDone());
        Assertions.assertEquals((Object)error, TestUtil.await(failureFuture));
        for (int i = 0; i < recordCount; ++i) {
            Record record = (Record)TestUtil.await(handler.nextAsync());
            Assertions.assertNotNull((Object)record);
            Assertions.assertEquals(keys, (Object)record.keys());
            Assertions.assertEquals((int)123, (int)record.get("key1").asInt());
            Assertions.assertEquals((int)456, (int)record.get("key2").asInt());
        }
        Assertions.assertNull(TestUtil.await(handler.nextAsync()));
    }

    @Test
    void shouldEnableAutoReadOnConnectionWhenFailureRequestedButNotAvailable() throws Exception {
        Connection connection = this.connectionMock();
        LegacyPullAllResponseHandler handler = (LegacyPullAllResponseHandler)this.newHandler(Arrays.asList("key1", "key2"), connection);
        handler.onRecord(Values.values((Object[])new Object[]{1, 2}));
        handler.onRecord(Values.values((Object[])new Object[]{3, 4}));
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).enableAutoRead();
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).disableAutoRead();
        CompletableFuture failureFuture = handler.pullAllFailureAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)failureFuture.isDone());
        ((Connection)Mockito.verify((Object)connection)).enableAutoRead();
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).disableAutoRead();
        Assertions.assertNotNull(TestUtil.await(handler.nextAsync()));
        Assertions.assertNotNull(TestUtil.await(handler.nextAsync()));
        RuntimeException error = new RuntimeException("Oh my!");
        handler.onFailure((Throwable)error);
        Assertions.assertTrue((boolean)failureFuture.isDone());
        Assertions.assertEquals((Object)error, failureFuture.get());
    }

    @Test
    void shouldNotDisableAutoReadWhenAutoReadManagementDisabled() {
        Connection connection = this.connectionMock();
        LegacyPullAllResponseHandler handler = (LegacyPullAllResponseHandler)this.newHandler(Arrays.asList("key1", "key2"), connection);
        handler.disableAutoReadManagement();
        for (int i = 0; i < LegacyPullAllResponseHandler.RECORD_BUFFER_HIGH_WATERMARK + 1; ++i) {
            handler.onRecord(Values.values((Object[])new Object[]{100, 200}));
        }
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).disableAutoRead();
    }

    @Test
    void shouldReturnEmptyListInListAsyncAfterFailure() {
        LegacyPullAllResponseHandler handler = (LegacyPullAllResponseHandler)this.newHandler();
        RuntimeException error = new RuntimeException("Hi");
        handler.onFailure((Throwable)error);
        Assertions.assertEquals((Object)error, TestUtil.await(handler.pullAllFailureAsync()));
        Assertions.assertEquals(Collections.emptyList(), TestUtil.await(handler.listAsync(Function.identity())));
    }

    @Test
    void shouldEnableAutoReadOnConnectionWhenSummaryRequestedButNotAvailable() throws Exception {
        Connection connection = this.connectionMock();
        Object handler = this.newHandler(Arrays.asList("key1", "key2", "key3"), connection);
        handler.onRecord(Values.values((Object[])new Object[]{1, 2, 3}));
        handler.onRecord(Values.values((Object[])new Object[]{4, 5, 6}));
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).enableAutoRead();
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).disableAutoRead();
        CompletableFuture summaryFuture = handler.consumeAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)summaryFuture.isDone());
        ((Connection)Mockito.verify((Object)connection)).enableAutoRead();
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).disableAutoRead();
        Assertions.assertNull(TestUtil.await(handler.nextAsync()));
        handler.onSuccess(Collections.emptyMap());
        Assertions.assertTrue((boolean)summaryFuture.isDone());
        Assertions.assertNotNull(summaryFuture.get());
    }

    @Override
    protected LegacyPullAllResponseHandler newHandler(Query query, List<String> queryKeys, Connection connection) {
        RunResponseHandler runResponseHandler = new RunResponseHandler(new CompletableFuture(), BoltProtocolV3.METADATA_EXTRACTOR, (Connection)Mockito.mock(Connection.class), null);
        runResponseHandler.onSuccess(Collections.singletonMap("fields", Values.value(queryKeys)));
        return new LegacyPullAllResponseHandler(query, runResponseHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, (PullResponseCompletionListener)Mockito.mock(PullResponseCompletionListener.class));
    }
}

