/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ConnectionReadTimeoutException;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.util.TestUtil;

class RunResponseHandlerTest {
    RunResponseHandlerTest() {
    }

    @Test
    void shouldNotifyRunFutureOnSuccess() throws Exception {
        CompletableFuture<Void> runFuture = new CompletableFuture<Void>();
        RunResponseHandler handler = RunResponseHandlerTest.newHandler(runFuture);
        Assertions.assertFalse((boolean)runFuture.isDone());
        handler.onSuccess(Collections.emptyMap());
        Assertions.assertTrue((boolean)runFuture.isDone());
        Assertions.assertNull((Object)runFuture.get());
    }

    @Test
    void shouldNotifyRunFutureOnFailure() {
        CompletableFuture<Void> runFuture = new CompletableFuture<Void>();
        RunResponseHandler handler = RunResponseHandlerTest.newHandler(runFuture);
        Assertions.assertFalse((boolean)runFuture.isDone());
        RuntimeException exception = new RuntimeException();
        handler.onFailure((Throwable)exception);
        Assertions.assertTrue((boolean)runFuture.isCompletedExceptionally());
        ExecutionException executionException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, runFuture::get);
        Assert.assertThat((Object)executionException.getCause(), (Matcher)CoreMatchers.equalTo((Object)exception));
    }

    @Test
    void shouldThrowOnRecord() {
        RunResponseHandler handler = RunResponseHandlerTest.newHandler();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> handler.onRecord(Values.values((Object[])new Object[]{"a", "b", "c"})));
    }

    @Test
    void shouldReturnNoKeysWhenFailed() {
        RunResponseHandler handler = RunResponseHandlerTest.newHandler();
        handler.onFailure((Throwable)new RuntimeException());
        Assertions.assertEquals(Collections.emptyList(), (Object)handler.queryKeys().keys());
        Assertions.assertEquals(Collections.emptyMap(), (Object)handler.queryKeys().keyIndex());
    }

    @Test
    void shouldReturnDefaultResultAvailableAfterWhenFailed() {
        RunResponseHandler handler = RunResponseHandlerTest.newHandler();
        handler.onFailure((Throwable)new RuntimeException());
        Assertions.assertEquals((long)-1L, (long)handler.resultAvailableAfter());
    }

    @Test
    void shouldReturnKeysWhenSucceeded() {
        RunResponseHandler handler = RunResponseHandlerTest.newHandler();
        List<String> keys = Arrays.asList("key1", "key2", "key3");
        HashMap<String, Integer> keyIndex = new HashMap<String, Integer>();
        keyIndex.put("key1", 0);
        keyIndex.put("key2", 1);
        keyIndex.put("key3", 2);
        handler.onSuccess(Collections.singletonMap("fields", Values.value(keys)));
        Assertions.assertEquals(keys, (Object)handler.queryKeys().keys());
        Assertions.assertEquals(keyIndex, (Object)handler.queryKeys().keyIndex());
    }

    @Test
    void shouldReturnResultAvailableAfterWhenSucceededV3() {
        RunResponseHandlerTest.testResultAvailableAfterOnSuccess("t_first", BoltProtocolV3.METADATA_EXTRACTOR);
    }

    @Test
    void shouldMarkTxAndKeepConnectionAndFailOnFailure() {
        CompletableFuture runFuture = new CompletableFuture();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        UnmanagedTransaction tx = (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class);
        RunResponseHandler handler = new RunResponseHandler(runFuture, BoltProtocolV3.METADATA_EXTRACTOR, connection, tx);
        RuntimeException throwable = new RuntimeException();
        Assertions.assertFalse((boolean)runFuture.isDone());
        handler.onFailure((Throwable)throwable);
        Assertions.assertTrue((boolean)runFuture.isCompletedExceptionally());
        Throwable actualException = Assertions.assertThrows(Throwable.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(runFuture);
        });
        Assertions.assertSame((Object)throwable, (Object)actualException);
        ((UnmanagedTransaction)Mockito.verify((Object)tx)).markTerminated((Throwable)throwable);
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).release();
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).terminateAndRelease((String)ArgumentMatchers.any(String.class));
    }

    @Test
    void shouldNotReleaseConnectionAndFailOnFailure() {
        CompletableFuture runFuture = new CompletableFuture();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RunResponseHandler handler = new RunResponseHandler(runFuture, BoltProtocolV3.METADATA_EXTRACTOR, connection, null);
        RuntimeException throwable = new RuntimeException();
        Assertions.assertFalse((boolean)runFuture.isDone());
        handler.onFailure((Throwable)throwable);
        Assertions.assertTrue((boolean)runFuture.isCompletedExceptionally());
        Throwable actualException = Assertions.assertThrows(Throwable.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(runFuture);
        });
        Assertions.assertSame((Object)throwable, (Object)actualException);
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).release();
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).terminateAndRelease((String)ArgumentMatchers.any(String.class));
    }

    @Test
    void shouldReleaseConnectionImmediatelyAndFailOnAuthorizationExpiredExceptionFailure() {
        CompletableFuture runFuture = new CompletableFuture();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RunResponseHandler handler = new RunResponseHandler(runFuture, BoltProtocolV3.METADATA_EXTRACTOR, connection, null);
        AuthorizationExpiredException authorizationExpiredException = new AuthorizationExpiredException("code", "message");
        Assertions.assertFalse((boolean)runFuture.isDone());
        handler.onFailure((Throwable)authorizationExpiredException);
        Assertions.assertTrue((boolean)runFuture.isCompletedExceptionally());
        AuthorizationExpiredException actualException = (AuthorizationExpiredException)Assertions.assertThrows(AuthorizationExpiredException.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(runFuture);
        });
        Assertions.assertSame((Object)authorizationExpiredException, (Object)actualException);
        ((Connection)Mockito.verify((Object)connection)).terminateAndRelease("Authorization information kept on the server has expired, this connection is no longer valid.");
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).release();
    }

    @Test
    void shouldReleaseConnectionImmediatelyAndFailOnConnectionReadTimeoutExceptionFailure() {
        CompletableFuture runFuture = new CompletableFuture();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RunResponseHandler handler = new RunResponseHandler(runFuture, BoltProtocolV3.METADATA_EXTRACTOR, connection, null);
        Assertions.assertFalse((boolean)runFuture.isDone());
        handler.onFailure((Throwable)ConnectionReadTimeoutException.INSTANCE);
        Assertions.assertTrue((boolean)runFuture.isCompletedExceptionally());
        ConnectionReadTimeoutException actualException = (ConnectionReadTimeoutException)Assertions.assertThrows(ConnectionReadTimeoutException.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(runFuture);
        });
        Assertions.assertSame((Object)ConnectionReadTimeoutException.INSTANCE, (Object)actualException);
        ((Connection)Mockito.verify((Object)connection)).terminateAndRelease(ConnectionReadTimeoutException.INSTANCE.getMessage());
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).release();
    }

    private static void testResultAvailableAfterOnSuccess(String key, MetadataExtractor metadataExtractor) {
        RunResponseHandler handler = RunResponseHandlerTest.newHandler(metadataExtractor);
        handler.onSuccess(Collections.singletonMap(key, Values.value((int)42)));
        Assertions.assertEquals((long)42L, (long)handler.resultAvailableAfter());
    }

    private static RunResponseHandler newHandler() {
        return RunResponseHandlerTest.newHandler(BoltProtocolV3.METADATA_EXTRACTOR);
    }

    private static RunResponseHandler newHandler(CompletableFuture<Void> runFuture) {
        return RunResponseHandlerTest.newHandler(runFuture, BoltProtocolV3.METADATA_EXTRACTOR);
    }

    private static RunResponseHandler newHandler(MetadataExtractor metadataExtractor) {
        return RunResponseHandlerTest.newHandler(new CompletableFuture<Void>(), metadataExtractor);
    }

    private static RunResponseHandler newHandler(CompletableFuture<Void> runFuture, MetadataExtractor metadataExtractor) {
        return new RunResponseHandler(runFuture, metadataExtractor, (Connection)Mockito.mock(Connection.class), null);
    }
}

