/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.Query;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.TransactionPullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.util.TestUtil;

class TransactionPullResponseCompletionListenerTest {
    TransactionPullResponseCompletionListenerTest() {
    }

    @Test
    void shouldMarkTransactionAsTerminatedOnFailures() {
        TransactionPullResponseCompletionListenerTest.testErrorHandling(new ClientException("Neo.ClientError.Cluster.NotALeader", ""));
        TransactionPullResponseCompletionListenerTest.testErrorHandling(new ClientException("Neo.ClientError.Procedure.ProcedureCallFailed", ""));
        TransactionPullResponseCompletionListenerTest.testErrorHandling(new TransientException("Neo.TransientError.Transaction.Terminated", ""));
        TransactionPullResponseCompletionListenerTest.testErrorHandling(new TransientException("Neo.TransientError.General.DatabaseUnavailable", ""));
        TransactionPullResponseCompletionListenerTest.testErrorHandling(new RuntimeException());
        TransactionPullResponseCompletionListenerTest.testErrorHandling(new IOException());
        TransactionPullResponseCompletionListenerTest.testErrorHandling((Throwable)new ServiceUnavailableException(""));
        TransactionPullResponseCompletionListenerTest.testErrorHandling((Throwable)new SessionExpiredException(""));
        TransactionPullResponseCompletionListenerTest.testErrorHandling((Throwable)new SessionExpiredException(""));
        TransactionPullResponseCompletionListenerTest.testErrorHandling(new ClientException("Neo.ClientError.Request.Invalid"));
    }

    private static void testErrorHandling(Throwable error) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.serverAddress()).thenReturn((Object)BoltServerAddress.LOCAL_DEFAULT);
        Mockito.when((Object)connection.serverVersion()).thenReturn((Object)TestUtil.anyServerVersion());
        Mockito.when((Object)connection.protocol()).thenReturn((Object)BoltProtocolV43.INSTANCE);
        Mockito.when((Object)connection.serverAgent()).thenReturn((Object)"Neo4j/4.2.5");
        UnmanagedTransaction tx = (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)true);
        TransactionPullResponseCompletionListener listener = new TransactionPullResponseCompletionListener(tx);
        RunResponseHandler runHandler = new RunResponseHandler(new CompletableFuture(), BoltProtocolV3.METADATA_EXTRACTOR, null, null);
        BasicPullResponseHandler handler = new BasicPullResponseHandler(new Query("RETURN 1"), runHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, (PullResponseCompletionListener)listener);
        handler.installRecordConsumer((record, throwable) -> {});
        handler.installSummaryConsumer((resultSummary, throwable) -> {});
        handler.onFailure(error);
        ((UnmanagedTransaction)Mockito.verify((Object)tx)).markTerminated(error);
    }
}

