/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers.pulln;

import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.request.DiscardMessage;
import org.neo4j.driver.internal.messaging.request.PullMessage;
import org.neo4j.driver.internal.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.summary.ResultSummary;

abstract class BasicPullResponseHandlerTestBase {
    BasicPullResponseHandlerTestBase() {
    }

    protected abstract void shouldHandleSuccessWithSummary(BasicPullResponseHandler.State var1);

    protected abstract void shouldHandleFailure(BasicPullResponseHandler.State var1);

    protected abstract BasicPullResponseHandler newResponseHandlerWithStatus(Connection var1, BiConsumer<Record, Throwable> var2, BiConsumer<ResultSummary, Throwable> var3, BasicPullResponseHandler.State var4);

    @ParameterizedTest
    @MethodSource(value={"allStatus"})
    void shouldSuccessWithSummary(BasicPullResponseHandler.State state) throws Throwable {
        this.shouldHandleSuccessWithSummary(state);
    }

    @Test
    void shouldRequestMoreWithHasMore() throws Throwable {
        Connection conn = BasicPullResponseHandlerTestBase.mockConnection();
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, BasicPullResponseHandler.State.STREAMING_STATE);
        handler.request(100L);
        handler.onSuccess(BasicPullResponseHandlerTestBase.metaWithHasMoreEqualsTrue());
        ((Connection)Mockito.verify((Object)conn)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.eq((Object)handler));
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.STREAMING_STATE));
    }

    @Test
    void shouldInformSummaryConsumerSuccessWithHasMore() throws Throwable {
        Connection conn = BasicPullResponseHandlerTestBase.mockConnection();
        BiConsumer recordConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BiConsumer summaryConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, recordConsumer, summaryConsumer, BasicPullResponseHandler.State.STREAMING_STATE);
        handler.onSuccess(BasicPullResponseHandlerTestBase.metaWithHasMoreEqualsTrue());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{conn});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{recordConsumer});
        ((BiConsumer)Mockito.verify((Object)summaryConsumer)).accept(null, null);
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.READY_STATE));
    }

    @Test
    void shouldDiscardIfStreamingIsCanceled() throws Throwable {
        Connection conn = BasicPullResponseHandlerTestBase.mockConnection();
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, BasicPullResponseHandler.State.CANCELLED_STATE);
        handler.onSuccess(BasicPullResponseHandlerTestBase.metaWithHasMoreEqualsTrue());
        ((Connection)Mockito.verify((Object)conn)).writeAndFlush((Message)ArgumentMatchers.any(DiscardMessage.class), (ResponseHandler)ArgumentMatchers.eq((Object)handler));
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.CANCELLED_STATE));
    }

    @ParameterizedTest
    @MethodSource(value={"allStatus"})
    void shouldErrorToRecordAndSummaryConsumer(BasicPullResponseHandler.State state) throws Throwable {
        this.shouldHandleFailure(state);
    }

    @Test
    void shouldReportRecordInStreaming() throws Throwable {
        Connection conn = BasicPullResponseHandlerTestBase.mockConnection();
        BiConsumer recordConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BiConsumer summaryConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, recordConsumer, summaryConsumer, BasicPullResponseHandler.State.STREAMING_STATE);
        handler.onRecord(new Value[0]);
        ((BiConsumer)Mockito.verify((Object)recordConsumer)).accept(ArgumentMatchers.any(Record.class), ArgumentMatchers.eq(null));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{summaryConsumer});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{conn});
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.STREAMING_STATE));
    }

    @ParameterizedTest
    @MethodSource(value={"allStatusExceptStreaming"})
    void shouldNotReportRecordWhenNotStreaming(BasicPullResponseHandler.State state) throws Throwable {
        Connection conn = BasicPullResponseHandlerTestBase.mockConnection();
        BiConsumer recordConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BiConsumer summaryConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, recordConsumer, summaryConsumer, state);
        handler.onRecord(new Value[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{recordConsumer});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{summaryConsumer});
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)state));
    }

    @Test
    void shouldStayInStreaming() throws Throwable {
        Connection conn = BasicPullResponseHandlerTestBase.mockConnection();
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, BasicPullResponseHandler.State.STREAMING_STATE);
        handler.request(100L);
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.STREAMING_STATE));
    }

    @Test
    void shouldPullAndSwitchStreamingInReady() throws Throwable {
        Connection conn = BasicPullResponseHandlerTestBase.mockConnection();
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, BasicPullResponseHandler.State.READY_STATE);
        handler.request(100L);
        ((Connection)Mockito.verify((Object)conn)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.eq((Object)handler));
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.STREAMING_STATE));
    }

    @Test
    void shouldStayInCancel() throws Throwable {
        Connection conn = BasicPullResponseHandlerTestBase.mockConnection();
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, BasicPullResponseHandler.State.CANCELLED_STATE);
        handler.cancel();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{conn});
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.CANCELLED_STATE));
    }

    @Test
    void shouldSwitchFromStreamingToCancel() throws Throwable {
        Connection conn = BasicPullResponseHandlerTestBase.mockConnection();
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, BasicPullResponseHandler.State.STREAMING_STATE);
        handler.cancel();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{conn});
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.CANCELLED_STATE));
    }

    @Test
    void shouldSwitchFromReadyToCancel() throws Throwable {
        Connection conn = BasicPullResponseHandlerTestBase.mockConnection();
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, BasicPullResponseHandler.State.READY_STATE);
        handler.cancel();
        ((Connection)Mockito.verify((Object)conn)).writeAndFlush((Message)ArgumentMatchers.any(DiscardMessage.class), (ResponseHandler)ArgumentMatchers.eq((Object)handler));
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.CANCELLED_STATE));
    }

    static Connection mockConnection() {
        Connection conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)conn.serverAddress()).thenReturn(Mockito.mock(BoltServerAddress.class));
        Mockito.when((Object)conn.serverVersion()).thenReturn(Mockito.mock(ServerVersion.class));
        Mockito.when((Object)conn.protocol()).thenReturn((Object)BoltProtocolV43.INSTANCE);
        Mockito.when((Object)conn.serverAgent()).thenReturn((Object)"Neo4j/4.2.5");
        return conn;
    }

    private BasicPullResponseHandler newResponseHandlerWithStatus(Connection conn, BasicPullResponseHandler.State state) {
        BiConsumer recordConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BiConsumer summaryConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        return this.newResponseHandlerWithStatus(conn, recordConsumer, summaryConsumer, state);
    }

    private static HashMap<String, Value> metaWithHasMoreEqualsTrue() {
        HashMap<String, Value> meta = new HashMap<String, Value>(1);
        meta.put("has_more", (Value)BooleanValue.TRUE);
        return meta;
    }

    private static Stream<BasicPullResponseHandler.State> allStatusExceptStreaming() {
        return Stream.of(BasicPullResponseHandler.State.SUCCEEDED_STATE, BasicPullResponseHandler.State.FAILURE_STATE, BasicPullResponseHandler.State.CANCELLED_STATE, BasicPullResponseHandler.State.READY_STATE);
    }

    private static Stream<BasicPullResponseHandler.State> allStatus() {
        return Stream.of(BasicPullResponseHandler.State.SUCCEEDED_STATE, BasicPullResponseHandler.State.FAILURE_STATE, BasicPullResponseHandler.State.CANCELLED_STATE, BasicPullResponseHandler.State.READY_STATE, BasicPullResponseHandler.State.STREAMING_STATE);
    }
}

