/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers.pulln;

import java.util.Collections;
import java.util.function.BiConsumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.SessionPullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandlerTestBase;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.summary.ResultSummary;

class SessionPullResponseCompletionListenerTest
extends BasicPullResponseHandlerTestBase {
    SessionPullResponseCompletionListenerTest() {
    }

    @Override
    protected void shouldHandleSuccessWithSummary(BasicPullResponseHandler.State state) {
        Connection conn = SessionPullResponseCompletionListenerTest.mockConnection();
        BiConsumer recordConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BiConsumer summaryConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BookmarkHolder bookmarkHolder = (BookmarkHolder)Mockito.mock(BookmarkHolder.class);
        BasicPullResponseHandler handler = SessionPullResponseCompletionListenerTest.newSessionResponseHandler(conn, recordConsumer, summaryConsumer, bookmarkHolder, state);
        handler.onSuccess(Collections.emptyMap());
        ((Connection)Mockito.verify((Object)conn)).release();
        ((BookmarkHolder)Mockito.verify((Object)bookmarkHolder)).setBookmark((Bookmark)ArgumentMatchers.any());
        ((BiConsumer)Mockito.verify((Object)recordConsumer)).accept(null, null);
        ((BiConsumer)Mockito.verify((Object)summaryConsumer)).accept(ArgumentMatchers.any(ResultSummary.class), ArgumentMatchers.eq(null));
    }

    @Override
    protected void shouldHandleFailure(BasicPullResponseHandler.State state) {
        Connection conn = SessionPullResponseCompletionListenerTest.mockConnection();
        BiConsumer recordConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BiConsumer summaryConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, recordConsumer, summaryConsumer, state);
        RuntimeException error = new RuntimeException("I am an error");
        handler.onFailure((Throwable)error);
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.FAILURE_STATE));
        ((Connection)Mockito.verify((Object)conn)).release();
        ((BiConsumer)Mockito.verify((Object)recordConsumer)).accept(null, error);
        ((BiConsumer)Mockito.verify((Object)summaryConsumer)).accept(ArgumentMatchers.any(ResultSummary.class), ArgumentMatchers.eq((Object)error));
    }

    @Override
    protected BasicPullResponseHandler newResponseHandlerWithStatus(Connection conn, BiConsumer<Record, Throwable> recordConsumer, BiConsumer<ResultSummary, Throwable> summaryConsumer, BasicPullResponseHandler.State state) {
        BookmarkHolder bookmarkHolder = BookmarkHolder.NO_OP;
        return SessionPullResponseCompletionListenerTest.newSessionResponseHandler(conn, recordConsumer, summaryConsumer, bookmarkHolder, state);
    }

    private static BasicPullResponseHandler newSessionResponseHandler(Connection conn, BiConsumer<Record, Throwable> recordConsumer, BiConsumer<ResultSummary, Throwable> summaryConsumer, BookmarkHolder bookmarkHolder, BasicPullResponseHandler.State state) {
        RunResponseHandler runHandler = (RunResponseHandler)Mockito.mock(RunResponseHandler.class);
        SessionPullResponseCompletionListener listener = new SessionPullResponseCompletionListener(conn, bookmarkHolder);
        BasicPullResponseHandler handler = new BasicPullResponseHandler((Query)Mockito.mock(Query.class), runHandler, conn, BoltProtocolV4.METADATA_EXTRACTOR, (PullResponseCompletionListener)listener);
        handler.installRecordConsumer(recordConsumer);
        handler.installSummaryConsumer(summaryConsumer);
        handler.state(state);
        return handler;
    }
}

