/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers.pulln;

import java.util.Collections;
import java.util.function.BiConsumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.TransactionPullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandlerTestBase;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.summary.ResultSummary;

public class TransactionPullResponseCompletionListenerTest
extends BasicPullResponseHandlerTestBase {
    @Override
    protected void shouldHandleSuccessWithSummary(BasicPullResponseHandler.State state) {
        Connection conn = TransactionPullResponseCompletionListenerTest.mockConnection();
        BiConsumer recordConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BiConsumer summaryConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BasicPullResponseHandler handler = this.newResponseHandlerWithStatus(conn, recordConsumer, summaryConsumer, state);
        handler.onSuccess(Collections.emptyMap());
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.SUCCEEDED_STATE));
        ((BiConsumer)Mockito.verify((Object)recordConsumer)).accept(null, null);
        ((BiConsumer)Mockito.verify((Object)summaryConsumer)).accept(ArgumentMatchers.any(ResultSummary.class), ArgumentMatchers.eq(null));
    }

    @Override
    protected void shouldHandleFailure(BasicPullResponseHandler.State state) {
        Connection conn = TransactionPullResponseCompletionListenerTest.mockConnection();
        BiConsumer recordConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        BiConsumer summaryConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        UnmanagedTransaction tx = (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)true);
        BasicPullResponseHandler handler = TransactionPullResponseCompletionListenerTest.newTxResponseHandler(conn, recordConsumer, summaryConsumer, tx, state);
        RuntimeException error = new RuntimeException("I am an error");
        handler.onFailure((Throwable)error);
        Assert.assertThat((Object)handler.state(), (Matcher)CoreMatchers.equalTo((Object)BasicPullResponseHandler.State.FAILURE_STATE));
        ((UnmanagedTransaction)Mockito.verify((Object)tx)).markTerminated((Throwable)error);
        ((BiConsumer)Mockito.verify((Object)recordConsumer)).accept(null, error);
        ((BiConsumer)Mockito.verify((Object)summaryConsumer)).accept(ArgumentMatchers.any(ResultSummary.class), ArgumentMatchers.eq((Object)error));
    }

    @Override
    protected BasicPullResponseHandler newResponseHandlerWithStatus(Connection conn, BiConsumer<Record, Throwable> recordConsumer, BiConsumer<ResultSummary, Throwable> summaryConsumer, BasicPullResponseHandler.State state) {
        UnmanagedTransaction tx = (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class);
        return TransactionPullResponseCompletionListenerTest.newTxResponseHandler(conn, recordConsumer, summaryConsumer, tx, state);
    }

    private static BasicPullResponseHandler newTxResponseHandler(Connection conn, BiConsumer<Record, Throwable> recordConsumer, BiConsumer<ResultSummary, Throwable> summaryConsumer, UnmanagedTransaction tx, BasicPullResponseHandler.State state) {
        RunResponseHandler runHandler = (RunResponseHandler)Mockito.mock(RunResponseHandler.class);
        TransactionPullResponseCompletionListener listener = new TransactionPullResponseCompletionListener(tx);
        BasicPullResponseHandler handler = new BasicPullResponseHandler((Query)Mockito.mock(Query.class), runHandler, conn, BoltProtocolV4.METADATA_EXTRACTOR, (PullResponseCompletionListener)listener);
        handler.installRecordConsumer(recordConsumer);
        handler.installSummaryConsumer(summaryConsumer);
        handler.state(state);
        return handler;
    }
}

