/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.messaging.v41.BoltProtocolV41;
import org.neo4j.driver.internal.messaging.v42.BoltProtocolV42;
import org.neo4j.driver.internal.messaging.v43.BoltProtocolV43;

class BoltProtocolTest {
    BoltProtocolTest() {
    }

    @Test
    void shouldCreateProtocolForKnownVersions() {
        Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)BoltProtocol.forVersion((BoltProtocolVersion)BoltProtocolV3.VERSION), (Matcher)Matchers.instanceOf(BoltProtocolV3.class)), () -> MatcherAssert.assertThat((Object)BoltProtocol.forVersion((BoltProtocolVersion)BoltProtocolV4.VERSION), (Matcher)Matchers.instanceOf(BoltProtocolV4.class)), () -> MatcherAssert.assertThat((Object)BoltProtocol.forVersion((BoltProtocolVersion)BoltProtocolV41.VERSION), (Matcher)Matchers.instanceOf(BoltProtocolV41.class)), () -> MatcherAssert.assertThat((Object)BoltProtocol.forVersion((BoltProtocolVersion)BoltProtocolV42.VERSION), (Matcher)Matchers.instanceOf(BoltProtocolV42.class)), () -> MatcherAssert.assertThat((Object)BoltProtocol.forVersion((BoltProtocolVersion)BoltProtocolV43.VERSION), (Matcher)Matchers.instanceOf(BoltProtocolV43.class))});
    }

    @Test
    void shouldThrowForUnknownVersion() {
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            ClientException cfr_ignored_0 = (ClientException)Assertions.assertThrows(ClientException.class, () -> BoltProtocol.forVersion((BoltProtocolVersion)new BoltProtocolVersion(42, 0)));
        }, () -> {
            ClientException cfr_ignored_0 = (ClientException)Assertions.assertThrows(ClientException.class, () -> BoltProtocol.forVersion((BoltProtocolVersion)new BoltProtocolVersion(142, 0)));
        }, () -> {
            ClientException cfr_ignored_0 = (ClientException)Assertions.assertThrows(ClientException.class, () -> BoltProtocol.forVersion((BoltProtocolVersion)new BoltProtocolVersion(-1, 0)));
        }});
    }

    @Test
    void shouldThrowForChannelWithUnknownProtocolVersion() {
        EmbeddedChannel channel = new EmbeddedChannel();
        ChannelAttributes.setProtocolVersion((Channel)channel, (BoltProtocolVersion)new BoltProtocolVersion(42, 0));
        Assertions.assertThrows(ClientException.class, () -> BoltProtocol.forChannel((Channel)channel));
    }
}

