/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.encode.RollbackMessageEncoder;
import org.neo4j.driver.internal.messaging.request.ResetMessage;
import org.neo4j.driver.internal.messaging.request.RollbackMessage;

class RollbackMessageEncoderTest {
    private final RollbackMessageEncoder encoder = new RollbackMessageEncoder();
    private final ValuePacker packer = (ValuePacker)Mockito.mock(ValuePacker.class);

    RollbackMessageEncoderTest() {
    }

    @Test
    void shouldEncodeRollbackMessage() throws Exception {
        this.encoder.encode(RollbackMessage.ROLLBACK, this.packer);
        ((ValuePacker)Mockito.verify((Object)this.packer)).packStructHeader(0, (byte)19);
    }

    @Test
    void shouldFailToEncodeWrongMessage() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.encoder.encode((Message)ResetMessage.RESET, this.packer));
    }
}

