/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.messaging.request.HelloMessage;

class HelloMessageTest {
    HelloMessageTest() {
    }

    @Test
    void shouldHaveCorrectMetadata() {
        HashMap<String, Value> authToken = new HashMap<String, Value>();
        authToken.put("user", Values.value((String)"Alice"));
        authToken.put("credentials", Values.value((String)"SecretPassword"));
        HelloMessage message = new HelloMessage("MyDriver/1.0.2", authToken, Collections.emptyMap(), false);
        HashMap<String, Value> expectedMetadata = new HashMap<String, Value>(authToken);
        expectedMetadata.put("user_agent", Values.value((String)"MyDriver/1.0.2"));
        expectedMetadata.put("routing", Values.value(Collections.emptyMap()));
        Assertions.assertEquals(expectedMetadata, (Object)message.metadata());
    }

    @Test
    void shouldHaveCorrectRoutingContext() {
        HashMap<String, Value> authToken = new HashMap<String, Value>();
        authToken.put("user", Values.value((String)"Alice"));
        authToken.put("credentials", Values.value((String)"SecretPassword"));
        HashMap<String, String> routingContext = new HashMap<String, String>();
        routingContext.put("region", "China");
        routingContext.put("speed", "Slow");
        HelloMessage message = new HelloMessage("MyDriver/1.0.2", authToken, routingContext, false);
        HashMap<String, Value> expectedMetadata = new HashMap<String, Value>(authToken);
        expectedMetadata.put("user_agent", Values.value((String)"MyDriver/1.0.2"));
        expectedMetadata.put("routing", Values.value(routingContext));
        Assertions.assertEquals(expectedMetadata, (Object)message.metadata());
    }

    @Test
    void shouldNotExposeCredentialsInToString() {
        HashMap<String, Value> authToken = new HashMap<String, Value>();
        authToken.put("principal", Values.value((String)"Alice"));
        authToken.put("credentials", Values.value((String)"SecretPassword"));
        HelloMessage message = new HelloMessage("MyDriver/1.0.2", authToken, Collections.emptyMap(), false);
        MatcherAssert.assertThat((Object)message.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"SecretPassword")));
    }
}

