/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v41;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.DefaultBookmarkHolder;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.handlers.BeginTxResponseHandler;
import org.neo4j.driver.internal.handlers.CommitTxResponseHandler;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RollbackTxResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.BeginMessage;
import org.neo4j.driver.internal.messaging.request.CommitMessage;
import org.neo4j.driver.internal.messaging.request.GoodbyeMessage;
import org.neo4j.driver.internal.messaging.request.HelloMessage;
import org.neo4j.driver.internal.messaging.request.PullMessage;
import org.neo4j.driver.internal.messaging.request.RollbackMessage;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.messaging.v4.MessageFormatV4;
import org.neo4j.driver.internal.messaging.v41.BoltProtocolV41;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.util.TestUtil;

public final class BoltProtocolV41Test {
    protected static final String QUERY_TEXT = "RETURN $x";
    protected static final Map<String, Value> PARAMS = Collections.singletonMap("x", Values.value((int)42));
    protected static final Query QUERY = new Query("RETURN $x", Values.value(PARAMS));
    protected final BoltProtocol protocol = this.createProtocol();
    private final EmbeddedChannel channel = new EmbeddedChannel();
    private final InboundMessageDispatcher messageDispatcher = new InboundMessageDispatcher((Channel)this.channel, Logging.none());
    private final TransactionConfig txConfig = TransactionConfig.builder().withTimeout(Duration.ofSeconds(12L)).withMetadata(Collections.singletonMap("key", Values.value((int)42))).build();

    private BoltProtocol createProtocol() {
        return BoltProtocolV41.INSTANCE;
    }

    @BeforeEach
    void beforeEach() {
        ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)this.messageDispatcher);
    }

    @AfterEach
    void afterEach() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    void shouldCreateMessageFormat() {
        MatcherAssert.assertThat((Object)this.protocol.createMessageFormat(), (Matcher)Matchers.instanceOf(this.expectedMessageFormatType()));
    }

    @Test
    void shouldInitializeChannel() {
        ChannelPromise promise = this.channel.newPromise();
        this.protocol.initializeChannel("MyDriver/0.0.1", (AuthToken)BoltProtocolV41Test.dummyAuthToken(), RoutingContext.EMPTY, promise);
        MatcherAssert.assertThat((Object)this.channel.outboundMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.channel.outboundMessages().poll(), (Matcher)Matchers.instanceOf(HelloMessage.class));
        Assertions.assertEquals((int)1, (int)this.messageDispatcher.queuedHandlersCount());
        Assertions.assertFalse((boolean)promise.isDone());
        HashMap<String, Value> metadata = new HashMap<String, Value>();
        metadata.put("server", Values.value((String)TestUtil.anyServerVersion().toString()));
        metadata.put("connection_id", Values.value((String)"bolt-42"));
        this.messageDispatcher.handleSuccessMessage(metadata);
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertTrue((boolean)promise.isSuccess());
    }

    @Test
    void shouldPrepareToCloseChannel() {
        this.protocol.prepareToCloseChannel((Channel)this.channel);
        MatcherAssert.assertThat((Object)this.channel.outboundMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.channel.outboundMessages().poll(), (Matcher)Matchers.instanceOf(GoodbyeMessage.class));
        Assertions.assertEquals((int)1, (int)this.messageDispatcher.queuedHandlersCount());
    }

    @Test
    void shouldFailToInitializeChannelWhenErrorIsReceived() {
        ChannelPromise promise = this.channel.newPromise();
        this.protocol.initializeChannel("MyDriver/2.2.1", (AuthToken)BoltProtocolV41Test.dummyAuthToken(), RoutingContext.EMPTY, promise);
        MatcherAssert.assertThat((Object)this.channel.outboundMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.channel.outboundMessages().poll(), (Matcher)Matchers.instanceOf(HelloMessage.class));
        Assertions.assertEquals((int)1, (int)this.messageDispatcher.queuedHandlersCount());
        Assertions.assertFalse((boolean)promise.isDone());
        this.messageDispatcher.handleFailureMessage("Neo.TransientError.General.DatabaseUnavailable", "Error!");
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertFalse((boolean)promise.isSuccess());
    }

    @Test
    void shouldBeginTransactionWithoutBookmark() {
        Connection connection = TestUtil.connectionMock(this.protocol);
        CompletionStage stage = this.protocol.beginTransaction(connection, InternalBookmark.empty(), TransactionConfig.empty());
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)new BeginMessage(InternalBookmark.empty(), TransactionConfig.empty(), DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE, null)), (ResponseHandler)ArgumentMatchers.any(BeginTxResponseHandler.class));
        Assertions.assertNull(TestUtil.await(stage));
    }

    @Test
    void shouldBeginTransactionWithBookmarks() {
        Connection connection = TestUtil.connectionMock(this.protocol);
        Bookmark bookmark = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx100");
        CompletionStage stage = this.protocol.beginTransaction(connection, bookmark, TransactionConfig.empty());
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)new BeginMessage(bookmark, TransactionConfig.empty(), DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE, null)), (ResponseHandler)ArgumentMatchers.any(BeginTxResponseHandler.class));
        Assertions.assertNull(TestUtil.await(stage));
    }

    @Test
    void shouldBeginTransactionWithConfig() {
        Connection connection = TestUtil.connectionMock(this.protocol);
        CompletionStage stage = this.protocol.beginTransaction(connection, InternalBookmark.empty(), this.txConfig);
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)new BeginMessage(InternalBookmark.empty(), this.txConfig, DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE, null)), (ResponseHandler)ArgumentMatchers.any(BeginTxResponseHandler.class));
        Assertions.assertNull(TestUtil.await(stage));
    }

    @Test
    void shouldBeginTransactionWithBookmarksAndConfig() {
        Connection connection = TestUtil.connectionMock(this.protocol);
        Bookmark bookmark = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx4242");
        CompletionStage stage = this.protocol.beginTransaction(connection, bookmark, this.txConfig);
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)new BeginMessage(bookmark, this.txConfig, DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE, null)), (ResponseHandler)ArgumentMatchers.any(BeginTxResponseHandler.class));
        Assertions.assertNull(TestUtil.await(stage));
    }

    @Test
    void shouldCommitTransaction() {
        String bookmarkString = "neo4j:bookmark:v1:tx4242";
        Connection connection = TestUtil.connectionMock(this.protocol);
        Mockito.when((Object)connection.protocol()).thenReturn((Object)this.protocol);
        ((Connection)Mockito.doAnswer(invocation -> {
            ResponseHandler commitHandler = (ResponseHandler)invocation.getArgument(1);
            commitHandler.onSuccess(Collections.singletonMap("bookmark", Values.value((String)bookmarkString)));
            return null;
        }).when((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)CommitMessage.COMMIT), (ResponseHandler)ArgumentMatchers.any());
        CompletionStage stage = this.protocol.commitTransaction(connection);
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)CommitMessage.COMMIT), (ResponseHandler)ArgumentMatchers.any(CommitTxResponseHandler.class));
        Assertions.assertEquals((Object)InternalBookmark.parse((String)bookmarkString), TestUtil.await(stage));
    }

    @Test
    void shouldRollbackTransaction() {
        Connection connection = TestUtil.connectionMock(this.protocol);
        CompletionStage stage = this.protocol.rollbackTransaction(connection);
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)RollbackMessage.ROLLBACK), (ResponseHandler)ArgumentMatchers.any(RollbackTxResponseHandler.class));
        Assertions.assertNull(TestUtil.await(stage));
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitTransactionAndWaitForRunResponse(AccessMode mode) throws Exception {
        this.testRunAndWaitForRunResponse(true, TransactionConfig.empty(), mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitWithConfigTransactionAndWaitForRunResponse(AccessMode mode) throws Exception {
        this.testRunAndWaitForRunResponse(true, this.txConfig, mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitTransactionAndWaitForSuccessRunResponse(AccessMode mode) throws Exception {
        this.testSuccessfulRunInAutoCommitTxWithWaitingForResponse(InternalBookmark.empty(), TransactionConfig.empty(), mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitTransactionWithBookmarkAndConfigAndWaitForSuccessRunResponse(AccessMode mode) throws Exception {
        this.testSuccessfulRunInAutoCommitTxWithWaitingForResponse(InternalBookmark.parse((String)"neo4j:bookmark:v1:tx65"), this.txConfig, mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitTransactionAndWaitForFailureRunResponse(AccessMode mode) throws Exception {
        this.testFailedRunInAutoCommitTxWithWaitingForResponse(InternalBookmark.empty(), TransactionConfig.empty(), mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitTransactionWithBookmarkAndConfigAndWaitForFailureRunResponse(AccessMode mode) throws Exception {
        this.testFailedRunInAutoCommitTxWithWaitingForResponse(InternalBookmark.parse((String)"neo4j:bookmark:v1:tx163"), this.txConfig, mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInUnmanagedTransactionAndWaitForRunResponse(AccessMode mode) throws Exception {
        this.testRunAndWaitForRunResponse(false, TransactionConfig.empty(), mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInUnmanagedTransactionAndWaitForSuccessRunResponse(AccessMode mode) throws Exception {
        this.testRunInUnmanagedTransactionAndWaitForRunResponse(true, mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInUnmanagedTransactionAndWaitForFailureRunResponse(AccessMode mode) throws Exception {
        this.testRunInUnmanagedTransactionAndWaitForRunResponse(false, mode);
    }

    @Test
    void databaseNameInBeginTransaction() {
        this.testDatabaseNameSupport(false);
    }

    @Test
    void databaseNameForAutoCommitTransactions() {
        this.testDatabaseNameSupport(true);
    }

    @Test
    void shouldSupportDatabaseNameInBeginTransaction() {
        CompletionStage txStage = this.protocol.beginTransaction(TestUtil.connectionMock("foo", this.protocol), InternalBookmark.empty(), TransactionConfig.empty());
        Assertions.assertDoesNotThrow(() -> (Void)TestUtil.await(txStage));
    }

    @Test
    void shouldNotSupportDatabaseNameForAutoCommitTransactions() {
        Assertions.assertDoesNotThrow(() -> this.protocol.runInAutoCommitTransaction(TestUtil.connectionMock("foo", this.protocol), new Query("RETURN 1"), BookmarkHolder.NO_OP, TransactionConfig.empty(), -1L));
    }

    private Class<? extends MessageFormat> expectedMessageFormatType() {
        return MessageFormatV4.class;
    }

    private void testFailedRunInAutoCommitTxWithWaitingForResponse(Bookmark bookmark, TransactionConfig config, AccessMode mode) throws Exception {
        Connection connection = TestUtil.connectionMock(mode, this.protocol);
        DefaultBookmarkHolder bookmarkHolder = new DefaultBookmarkHolder(bookmark);
        CompletableFuture cursorFuture = this.protocol.runInAutoCommitTransaction(connection, QUERY, (BookmarkHolder)bookmarkHolder, config, -1L).asyncResult().toCompletableFuture();
        ResponseHandler runHandler = this.verifySessionRunInvoked(connection, bookmark, config, mode, DatabaseNameUtil.defaultDatabase());
        Assertions.assertFalse((boolean)cursorFuture.isDone());
        RuntimeException error = new RuntimeException();
        runHandler.onFailure((Throwable)error);
        Assertions.assertEquals((Object)bookmark, (Object)bookmarkHolder.getBookmark());
        Assertions.assertTrue((boolean)cursorFuture.isDone());
        Throwable actual = Assertions.assertThrows(error.getClass(), () -> {
            AsyncResultCursor cfr_ignored_0 = (AsyncResultCursor)TestUtil.await(((AsyncResultCursor)cursorFuture.get()).mapSuccessfulRunCompletionAsync());
        });
        Assertions.assertSame((Object)error, (Object)actual);
    }

    private void testSuccessfulRunInAutoCommitTxWithWaitingForResponse(Bookmark bookmark, TransactionConfig config, AccessMode mode) throws Exception {
        Connection connection = TestUtil.connectionMock(mode, this.protocol);
        DefaultBookmarkHolder bookmarkHolder = new DefaultBookmarkHolder(bookmark);
        CompletableFuture cursorFuture = this.protocol.runInAutoCommitTransaction(connection, QUERY, (BookmarkHolder)bookmarkHolder, config, -1L).asyncResult().toCompletableFuture();
        ResponseHandler runHandler = this.verifySessionRunInvoked(connection, bookmark, config, mode, DatabaseNameUtil.defaultDatabase());
        Assertions.assertFalse((boolean)cursorFuture.isDone());
        runHandler.onSuccess(Collections.emptyMap());
        Assertions.assertEquals((Object)bookmark, (Object)bookmarkHolder.getBookmark());
        Assertions.assertTrue((boolean)cursorFuture.isDone());
        Assertions.assertNotNull(cursorFuture.get());
    }

    private void testRunInUnmanagedTransactionAndWaitForRunResponse(boolean success, AccessMode mode) throws Exception {
        Connection connection = TestUtil.connectionMock(mode, this.protocol);
        CompletableFuture cursorFuture = this.protocol.runInUnmanagedTransaction(connection, QUERY, (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class), -1L).asyncResult().toCompletableFuture();
        ResponseHandler runHandler = this.verifyTxRunInvoked(connection);
        Assertions.assertFalse((boolean)cursorFuture.isDone());
        RuntimeException error = new RuntimeException();
        if (success) {
            runHandler.onSuccess(Collections.emptyMap());
        } else {
            runHandler.onFailure((Throwable)error);
        }
        Assertions.assertTrue((boolean)cursorFuture.isDone());
        if (success) {
            Assertions.assertNotNull(TestUtil.await(((AsyncResultCursor)cursorFuture.get()).mapSuccessfulRunCompletionAsync()));
        } else {
            Throwable actual = Assertions.assertThrows(error.getClass(), () -> {
                AsyncResultCursor cfr_ignored_0 = (AsyncResultCursor)TestUtil.await(((AsyncResultCursor)cursorFuture.get()).mapSuccessfulRunCompletionAsync());
            });
            Assertions.assertSame((Object)error, (Object)actual);
        }
    }

    private void testRunAndWaitForRunResponse(boolean autoCommitTx, TransactionConfig config, AccessMode mode) throws Exception {
        CompletionStage cursorStage;
        Connection connection = TestUtil.connectionMock(mode, this.protocol);
        Bookmark initialBookmark = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx987");
        if (autoCommitTx) {
            DefaultBookmarkHolder bookmarkHolder = new DefaultBookmarkHolder(initialBookmark);
            cursorStage = this.protocol.runInAutoCommitTransaction(connection, QUERY, (BookmarkHolder)bookmarkHolder, config, -1L).asyncResult();
        } else {
            cursorStage = this.protocol.runInUnmanagedTransaction(connection, QUERY, (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class), -1L).asyncResult();
        }
        CompletableFuture cursorFuture = cursorStage.toCompletableFuture();
        Assertions.assertFalse((boolean)cursorFuture.isDone());
        ResponseHandler runResponseHandler = autoCommitTx ? this.verifySessionRunInvoked(connection, initialBookmark, config, mode, DatabaseNameUtil.defaultDatabase()) : this.verifyTxRunInvoked(connection);
        runResponseHandler.onSuccess(Collections.emptyMap());
        Assertions.assertTrue((boolean)cursorFuture.isDone());
        Assertions.assertNotNull(cursorFuture.get());
    }

    private void testDatabaseNameSupport(boolean autoCommitTx) {
        Connection connection = TestUtil.connectionMock("foo", this.protocol);
        if (autoCommitTx) {
            ResultCursorFactory factory = this.protocol.runInAutoCommitTransaction(connection, QUERY, BookmarkHolder.NO_OP, TransactionConfig.empty(), -1L);
            CompletionStage resultStage = factory.asyncResult();
            ResponseHandler runHandler = this.verifySessionRunInvoked(connection, InternalBookmark.empty(), TransactionConfig.empty(), AccessMode.WRITE, DatabaseNameUtil.database((String)"foo"));
            runHandler.onSuccess(Collections.emptyMap());
            TestUtil.await(resultStage);
            this.verifySessionRunInvoked(connection, InternalBookmark.empty(), TransactionConfig.empty(), AccessMode.WRITE, DatabaseNameUtil.database((String)"foo"));
        } else {
            CompletionStage txStage = this.protocol.beginTransaction(connection, InternalBookmark.empty(), TransactionConfig.empty());
            TestUtil.await(txStage);
            this.verifyBeginInvoked(connection, InternalBookmark.empty(), TransactionConfig.empty(), AccessMode.WRITE, DatabaseNameUtil.database((String)"foo"));
        }
    }

    private ResponseHandler verifyTxRunInvoked(Connection connection) {
        return this.verifyRunInvoked(connection, RunWithMetadataMessage.unmanagedTxRunMessage((Query)QUERY));
    }

    private ResponseHandler verifySessionRunInvoked(Connection connection, Bookmark bookmark, TransactionConfig config, AccessMode mode, DatabaseName databaseName) {
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.autoCommitTxRunMessage((Query)QUERY, (TransactionConfig)config, (DatabaseName)databaseName, (AccessMode)mode, (Bookmark)bookmark, null);
        return this.verifyRunInvoked(connection, runMessage);
    }

    private ResponseHandler verifyRunInvoked(Connection connection, RunWithMetadataMessage runMessage) {
        ArgumentCaptor runHandlerCaptor = ArgumentCaptor.forClass(ResponseHandler.class);
        ArgumentCaptor pullHandlerCaptor = ArgumentCaptor.forClass(ResponseHandler.class);
        ((Connection)Mockito.verify((Object)connection)).write((Message)ArgumentMatchers.eq((Object)runMessage), (ResponseHandler)runHandlerCaptor.capture());
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)pullHandlerCaptor.capture());
        MatcherAssert.assertThat((Object)runHandlerCaptor.getValue(), (Matcher)Matchers.instanceOf(RunResponseHandler.class));
        MatcherAssert.assertThat((Object)pullHandlerCaptor.getValue(), (Matcher)Matchers.instanceOf(PullAllResponseHandler.class));
        return (ResponseHandler)runHandlerCaptor.getValue();
    }

    private void verifyBeginInvoked(Connection connection, Bookmark bookmark, TransactionConfig config, AccessMode mode, DatabaseName databaseName) {
        ArgumentCaptor beginHandlerCaptor = ArgumentCaptor.forClass(ResponseHandler.class);
        BeginMessage beginMessage = new BeginMessage(bookmark, config, databaseName, mode, null);
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)beginMessage), (ResponseHandler)beginHandlerCaptor.capture());
        MatcherAssert.assertThat((Object)beginHandlerCaptor.getValue(), (Matcher)Matchers.instanceOf(BeginTxResponseHandler.class));
    }

    private static InternalAuthToken dummyAuthToken() {
        return (InternalAuthToken)AuthTokens.basic((String)"hello", (String)"world");
    }
}

