/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v44;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.BeginMessage;
import org.neo4j.driver.internal.messaging.request.CommitMessage;
import org.neo4j.driver.internal.messaging.request.DiscardAllMessage;
import org.neo4j.driver.internal.messaging.request.DiscardMessage;
import org.neo4j.driver.internal.messaging.request.GoodbyeMessage;
import org.neo4j.driver.internal.messaging.request.HelloMessage;
import org.neo4j.driver.internal.messaging.request.PullAllMessage;
import org.neo4j.driver.internal.messaging.request.PullMessage;
import org.neo4j.driver.internal.messaging.request.ResetMessage;
import org.neo4j.driver.internal.messaging.request.RollbackMessage;
import org.neo4j.driver.internal.messaging.request.RouteMessage;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.messaging.v44.BoltProtocolV44;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.util.messaging.AbstractMessageWriterTestBase;

public class MessageWriterV44Test
extends AbstractMessageWriterTestBase {
    @Override
    protected MessageFormat.Writer newWriter(PackOutput output) {
        return BoltProtocolV44.INSTANCE.createMessageFormat().newWriter(output);
    }

    @Override
    protected Stream<Message> supportedMessages() {
        return Stream.of(RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN $point", Collections.singletonMap("point", Values.point((int)42, (double)12.99, (double)-180.0)))), RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN $point", Collections.singletonMap("point", Values.point((int)42, (double)0.51, (double)2.99, (double)100.123)))), RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN $date", Collections.singletonMap("date", Values.value((LocalDate)LocalDate.ofEpochDay(0x80000002L))))), RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN $time", Collections.singletonMap("time", Values.value((OffsetTime)OffsetTime.of(4, 16, 20, 999, ZoneOffset.MIN))))), RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN $time", Collections.singletonMap("time", Values.value((LocalTime)LocalTime.of(12, 9, 18, 999888))))), RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN $dateTime", Collections.singletonMap("dateTime", Values.value((LocalDateTime)LocalDateTime.of(2049, 11, 12, 17, 25, 49, 199))))), RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN $dateTime", Collections.singletonMap("dateTime", Values.value((ZonedDateTime)ZonedDateTime.of(2000, 1, 10, 12, 2, 49, 300, ZoneOffset.ofHoursMinutes(9, 30)))))), RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN $dateTime", Collections.singletonMap("dateTime", Values.value((ZonedDateTime)ZonedDateTime.of(2000, 1, 10, 12, 2, 49, 300, ZoneId.of("Europe/Stockholm")))))), new PullMessage(100L, 200L), new DiscardMessage(300L, 400L), new HelloMessage("MyDriver/1.2.3", ((InternalAuthToken)AuthTokens.basic((String)"neo4j", (String)"neo4j")).toMap(), Collections.emptyMap(), false), GoodbyeMessage.GOODBYE, new BeginMessage(InternalBookmark.parse((String)"neo4j:bookmark:v1:tx123"), Duration.ofSeconds(5L), Collections.singletonMap("key", Values.value((int)42)), AccessMode.READ, DatabaseNameUtil.defaultDatabase(), null), new BeginMessage(InternalBookmark.parse((String)"neo4j:bookmark:v1:tx123"), Duration.ofSeconds(5L), Collections.singletonMap("key", Values.value((int)42)), AccessMode.WRITE, DatabaseNameUtil.database((String)"foo"), null), CommitMessage.COMMIT, RollbackMessage.ROLLBACK, ResetMessage.RESET, RunWithMetadataMessage.autoCommitTxRunMessage((Query)new Query("RETURN 1"), (Duration)Duration.ofSeconds(5L), Collections.singletonMap("key", Values.value((int)42)), (DatabaseName)DatabaseNameUtil.defaultDatabase(), (AccessMode)AccessMode.READ, (Bookmark)InternalBookmark.parse((String)"neo4j:bookmark:v1:tx1"), null), RunWithMetadataMessage.autoCommitTxRunMessage((Query)new Query("RETURN 1"), (Duration)Duration.ofSeconds(5L), Collections.singletonMap("key", Values.value((int)42)), (DatabaseName)DatabaseNameUtil.database((String)"foo"), (AccessMode)AccessMode.WRITE, (Bookmark)InternalBookmark.parse((String)"neo4j:bookmark:v1:tx1"), null), RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), RunWithMetadataMessage.autoCommitTxRunMessage((Query)new Query("RETURN $x", Collections.singletonMap("x", Values.value((ZonedDateTime)ZonedDateTime.now()))), (Duration)Duration.ofSeconds(1L), Collections.emptyMap(), (DatabaseName)DatabaseNameUtil.defaultDatabase(), (AccessMode)AccessMode.READ, (Bookmark)InternalBookmark.empty(), null), RunWithMetadataMessage.autoCommitTxRunMessage((Query)new Query("RETURN $x", Collections.singletonMap("x", Values.value((ZonedDateTime)ZonedDateTime.now()))), (Duration)Duration.ofSeconds(1L), Collections.emptyMap(), (DatabaseName)DatabaseNameUtil.database((String)"foo"), (AccessMode)AccessMode.WRITE, (Bookmark)InternalBookmark.empty(), null), RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN $x", Collections.singletonMap("x", Values.point((int)42, (double)1.0, (double)2.0, (double)3.0)))), this.routeMessage());
    }

    @Override
    protected Stream<Message> unsupportedMessages() {
        return Stream.of(PullAllMessage.PULL_ALL, DiscardAllMessage.DISCARD_ALL);
    }

    private RouteMessage routeMessage() {
        HashMap<String, Value> routeContext = new HashMap<String, Value>();
        routeContext.put("someContext", Values.value((int)124));
        return new RouteMessage(routeContext, InternalBookmark.empty(), "dbName", null);
    }
}

