/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.neo4j.driver.ConnectionPoolMetrics;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.metrics.ConnectionPoolMetricsListener;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.MicrometerMetrics;
import org.neo4j.driver.internal.metrics.MicrometerTimerListenerEvent;
import org.neo4j.driver.net.ServerAddress;

class MicrometerMetricsTest {
    static final String ID = "id";
    MicrometerMetrics metrics;
    MeterRegistry registry;
    ConnectionPoolMetrics poolMetrics;
    ConnectionPoolMetricsListener poolMetricsListener;

    MicrometerMetricsTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.registry = new SimpleMeterRegistry();
        this.metrics = new MicrometerMetrics(this.registry);
        this.poolMetricsListener = (ConnectionPoolMetricsListener)Mockito.mock(ConnectionPoolMetricsListener.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{ConnectionPoolMetrics.class}));
        this.poolMetrics = (ConnectionPoolMetrics)this.poolMetricsListener;
    }

    @Test
    void shouldReturnEmptyConnectionPoolMetrics() {
        Collection collection = this.metrics.connectionPoolMetrics();
        Assertions.assertTrue((boolean)collection.isEmpty());
    }

    @Test
    void shouldDelegateBeforeCreating() {
        ListenerEvent event = (ListenerEvent)Mockito.mock(ListenerEvent.class);
        this.metrics.putPoolMetrics(ID, this.poolMetrics);
        this.metrics.beforeCreating(ID, event);
        Assertions.assertEquals((int)1, (int)this.metrics.connectionPoolMetrics().size());
        ((ConnectionPoolMetricsListener)BDDMockito.then((Object)this.poolMetricsListener).should()).beforeCreating(event);
    }

    @Test
    void shouldDelegateAfterCreated() {
        ListenerEvent event = (ListenerEvent)Mockito.mock(ListenerEvent.class);
        this.metrics.putPoolMetrics(ID, this.poolMetrics);
        this.metrics.afterCreated(ID, event);
        Assertions.assertEquals((int)1, (int)this.metrics.connectionPoolMetrics().size());
        ((ConnectionPoolMetricsListener)BDDMockito.then((Object)this.poolMetricsListener).should()).afterCreated(event);
    }

    @Test
    void shouldDelegateAfterFailedToCreate() {
        this.metrics.putPoolMetrics(ID, this.poolMetrics);
        this.metrics.afterFailedToCreate(ID);
        Assertions.assertEquals((int)1, (int)this.metrics.connectionPoolMetrics().size());
        ((ConnectionPoolMetricsListener)BDDMockito.then((Object)this.poolMetricsListener).should()).afterFailedToCreate();
    }

    @Test
    void shouldDelegateAfterClosed() {
        this.metrics.putPoolMetrics(ID, this.poolMetrics);
        this.metrics.afterClosed(ID);
        Assertions.assertEquals((int)1, (int)this.metrics.connectionPoolMetrics().size());
        ((ConnectionPoolMetricsListener)BDDMockito.then((Object)this.poolMetricsListener).should()).afterClosed();
    }

    @Test
    void shouldDelegateBeforeAcquiringOrCreating() {
        ListenerEvent event = (ListenerEvent)Mockito.mock(ListenerEvent.class);
        this.metrics.putPoolMetrics(ID, this.poolMetrics);
        this.metrics.beforeAcquiringOrCreating(ID, event);
        Assertions.assertEquals((int)1, (int)this.metrics.connectionPoolMetrics().size());
        ((ConnectionPoolMetricsListener)BDDMockito.then((Object)this.poolMetricsListener).should()).beforeAcquiringOrCreating(event);
    }

    @Test
    void shouldDelegateAfterAcquiringOrCreating() {
        this.metrics.putPoolMetrics(ID, this.poolMetrics);
        this.metrics.afterAcquiringOrCreating(ID);
        Assertions.assertEquals((int)1, (int)this.metrics.connectionPoolMetrics().size());
        ((ConnectionPoolMetricsListener)BDDMockito.then((Object)this.poolMetricsListener).should()).afterAcquiringOrCreating();
    }

    @Test
    void shouldDelegateAfterAcquiredOrCreated() {
        ListenerEvent event = (ListenerEvent)Mockito.mock(ListenerEvent.class);
        this.metrics.putPoolMetrics(ID, this.poolMetrics);
        this.metrics.afterAcquiredOrCreated(ID, event);
        Assertions.assertEquals((int)1, (int)this.metrics.connectionPoolMetrics().size());
        ((ConnectionPoolMetricsListener)BDDMockito.then((Object)this.poolMetricsListener).should()).afterAcquiredOrCreated(event);
    }

    @Test
    void shouldDelegateAfterTimedOutToAcquireOrCreate() {
        this.metrics.putPoolMetrics(ID, this.poolMetrics);
        this.metrics.afterTimedOutToAcquireOrCreate(ID);
        Assertions.assertEquals((int)1, (int)this.metrics.connectionPoolMetrics().size());
        ((ConnectionPoolMetricsListener)BDDMockito.then((Object)this.poolMetricsListener).should()).afterTimedOutToAcquireOrCreate();
    }

    @Test
    void shouldDelegateAfterConnectionCreated() {
        ListenerEvent event = (ListenerEvent)Mockito.mock(ListenerEvent.class);
        this.metrics.putPoolMetrics(ID, this.poolMetrics);
        this.metrics.afterConnectionCreated(ID, event);
        Assertions.assertEquals((int)1, (int)this.metrics.connectionPoolMetrics().size());
        ((ConnectionPoolMetricsListener)BDDMockito.then((Object)this.poolMetricsListener).should()).acquired(event);
    }

    @Test
    void shouldDelegateAfterConnectionReleased() {
        ListenerEvent event = (ListenerEvent)Mockito.mock(ListenerEvent.class);
        this.metrics.putPoolMetrics(ID, this.poolMetrics);
        this.metrics.afterConnectionReleased(ID, event);
        Assertions.assertEquals((int)1, (int)this.metrics.connectionPoolMetrics().size());
        ((ConnectionPoolMetricsListener)BDDMockito.then((Object)this.poolMetricsListener).should()).released(event);
    }

    @Test
    void shouldCreateListenerEvent() {
        ListenerEvent event = this.metrics.createListenerEvent();
        Assertions.assertTrue((boolean)(event instanceof MicrometerTimerListenerEvent));
    }

    @Test
    void shouldPutPoolMetrics() {
        int size = this.metrics.connectionPoolMetrics().size();
        this.metrics.registerPoolMetrics(ID, (ServerAddress)BoltServerAddress.LOCAL_DEFAULT, () -> 23, () -> 42);
        Assertions.assertEquals((int)(size + 1), (int)this.metrics.connectionPoolMetrics().size());
    }

    @Test
    void shouldRemovePoolMetrics() {
        this.metrics.putPoolMetrics(ID, this.poolMetrics);
        int size = this.metrics.connectionPoolMetrics().size();
        this.metrics.removePoolMetrics(ID);
        Assertions.assertEquals((int)(size - 1), (int)this.metrics.connectionPoolMetrics().size());
    }
}

