/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.neo4j.driver.internal.util.Futures;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.BaseSubscriber;
import reactor.test.StepVerifier;

class RxUtilsTest {
    RxUtilsTest() {
    }

    @Test
    void emptyPublisherShouldComplete() {
        Publisher emptyPublisher = RxUtils.createEmptyPublisher(Futures::completedWithNull);
        StepVerifier.create((Publisher)emptyPublisher).verifyComplete();
    }

    @Test
    void emptyPublisherShouldErrorWhenSupplierErrors() {
        RuntimeException error = new RuntimeException("Error");
        Publisher emptyPublisher = RxUtils.createEmptyPublisher(() -> Futures.failedFuture((Throwable)error));
        StepVerifier.create((Publisher)emptyPublisher).verifyErrorMatches(Predicate.isEqual(error));
    }

    @Test
    void singleItemPublisherShouldCompleteWithValue() {
        Publisher publisher = RxUtils.createSingleItemPublisher(() -> CompletableFuture.completedFuture("One"), () -> (Throwable)Mockito.mock(Throwable.class), ignored -> {});
        StepVerifier.create((Publisher)publisher).expectNext((Object)"One").verifyComplete();
    }

    @Test
    void singleItemPublisherShouldErrorWhenFutureCompletesWithNull() {
        Throwable error = (Throwable)Mockito.mock(Throwable.class);
        Publisher publisher = RxUtils.createSingleItemPublisher(Futures::completedWithNull, () -> error, ignored -> {});
        StepVerifier.create((Publisher)publisher).verifyErrorMatches(actualError -> error == actualError);
    }

    @Test
    void singleItemPublisherShouldErrorWhenSupplierErrors() {
        RuntimeException error = (RuntimeException)Mockito.mock(RuntimeException.class);
        Publisher publisher = RxUtils.createSingleItemPublisher(() -> Futures.failedFuture((Throwable)error), () -> (Throwable)Mockito.mock(Throwable.class), ignored -> {});
        StepVerifier.create((Publisher)publisher).verifyErrorMatches(actualError -> error == actualError);
    }

    @Test
    void singleItemPublisherShouldHandleCancellationAfterRequestProcessingBegins() {
        final String value = "value";
        final CompletableFuture valueFuture = new CompletableFuture();
        final CompletableFuture supplierInvokedFuture = new CompletableFuture();
        Supplier<CompletionStage> valueFutureSupplier = () -> {
            supplierInvokedFuture.complete(null);
            return valueFuture;
        };
        Consumer cancellationHandler = (Consumer)Mockito.mock(Consumer.class);
        Publisher publisher = RxUtils.createSingleItemPublisher(valueFutureSupplier, () -> (Throwable)Mockito.mock(Throwable.class), (Consumer)cancellationHandler);
        publisher.subscribe((Subscriber)new BaseSubscriber<String>(){

            protected void hookOnSubscribe(Subscription subscription) {
                subscription.request(1L);
                supplierInvokedFuture.thenAccept(ignored -> {
                    subscription.cancel();
                    valueFuture.complete(value);
                });
            }
        });
        valueFuture.join();
        ((Consumer)BDDMockito.then((Object)cancellationHandler).should()).accept(value);
    }
}

