/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.internal.util.QueryKeys;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.summary.ResultSummary;

public class ListBasedPullHandler
extends BasicPullResponseHandler {
    private final List<Record> list;
    private final Throwable error;
    private int index = 0;

    public ListBasedPullHandler() {
        this(Collections.emptyList(), null);
    }

    public ListBasedPullHandler(List<Record> list) {
        this(list, null);
    }

    public ListBasedPullHandler(Throwable error) {
        this(Collections.emptyList(), error);
    }

    private ListBasedPullHandler(List<Record> list, Throwable error) {
        super((Query)Mockito.mock(Query.class), (RunResponseHandler)Mockito.mock(RunResponseHandler.class), (Connection)Mockito.mock(Connection.class), (MetadataExtractor)Mockito.mock(MetadataExtractor.class), (PullResponseCompletionListener)Mockito.mock(PullResponseCompletionListener.class));
        this.list = list;
        this.error = error;
        Mockito.when((Object)this.metadataExtractor.extractSummary((Query)ArgumentMatchers.any(Query.class), (Connection)ArgumentMatchers.any(Connection.class), ArgumentMatchers.anyLong(), (Map)ArgumentMatchers.any(Map.class))).thenReturn(Mockito.mock(ResultSummary.class));
        if (list.size() > 1) {
            Record record = list.get(0);
            Mockito.when((Object)this.runResponseHandler.queryKeys()).thenReturn((Object)new QueryKeys(record.keys()));
        }
    }

    public void request(long n) {
        super.request(n);
        while (this.index < this.list.size() && (n == -1L || n-- > 0L)) {
            this.onRecord(this.list.get(this.index++).values().toArray(new Value[0]));
        }
        if (this.index == this.list.size()) {
            this.complete();
        } else {
            this.onSuccess(Collections.singletonMap("has_more", BooleanValue.TRUE));
        }
    }

    public void cancel() {
        super.cancel();
        this.complete();
    }

    private void complete() {
        if (this.error != null) {
            this.onFailure(this.error);
        } else {
            this.onSuccess(Collections.emptyMap());
        }
    }
}

