/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.summary.InternalPlan;
import org.neo4j.driver.summary.Plan;

class InternalPlanTest {
    InternalPlanTest() {
    }

    @Test
    void shouldConvertFromEmptyMapValue() {
        Value value = Values.value((Object)Values.parameters((Object[])new Object[]{"operatorType", "X"}));
        Plan plan = (Plan)InternalPlan.EXPLAIN_PLAN_FROM_VALUE.apply(value);
        MatcherAssert.assertThat((Object)plan.operatorType(), (Matcher)Matchers.equalTo((Object)"X"));
        MatcherAssert.assertThat((Object)plan.arguments(), (Matcher)Matchers.equalTo((Object)Values.parameters((Object[])new Object[0]).asMap(Values.ofValue())));
        MatcherAssert.assertThat((Object)plan.identifiers(), (Matcher)Matchers.equalTo(Collections.emptyList()));
        MatcherAssert.assertThat((Object)plan.children(), (Matcher)Matchers.equalTo(Collections.emptyList()));
    }

    @Test
    void shouldConvertFromSimpleMapValue() {
        Value value = Values.value((Object)Values.parameters((Object[])new Object[]{"operatorType", "X", "args", Values.parameters((Object[])new Object[]{"a", 1}), "identifiers", Values.values((Object[])new Object[0]), "children", Values.values((Object[])new Object[0])}));
        Plan plan = (Plan)InternalPlan.EXPLAIN_PLAN_FROM_VALUE.apply(value);
        MatcherAssert.assertThat((Object)plan.operatorType(), (Matcher)Matchers.equalTo((Object)"X"));
        MatcherAssert.assertThat((Object)plan.arguments(), (Matcher)Matchers.equalTo((Object)Values.parameters((Object[])new Object[]{"a", 1}).asMap(Values.ofValue())));
        MatcherAssert.assertThat((Object)plan.identifiers(), (Matcher)Matchers.equalTo(Collections.emptyList()));
        MatcherAssert.assertThat((Object)plan.children(), (Matcher)Matchers.equalTo(Collections.emptyList()));
    }

    @Test
    void shouldConvertFromNestedMapValue() {
        Value value = Values.value((Object)Values.parameters((Object[])new Object[]{"operatorType", "X", "args", Values.parameters((Object[])new Object[]{"a", 1}), "identifiers", Values.values((Object[])new Object[0]), "children", Values.values((Object[])new Object[]{Values.parameters((Object[])new Object[]{"operatorType", "Y"})})}));
        Plan plan = (Plan)InternalPlan.EXPLAIN_PLAN_FROM_VALUE.apply(value);
        MatcherAssert.assertThat((Object)plan.operatorType(), (Matcher)Matchers.equalTo((Object)"X"));
        MatcherAssert.assertThat((Object)plan.arguments(), (Matcher)Matchers.equalTo((Object)Values.parameters((Object[])new Object[]{"a", 1}).asMap(Values.ofValue())));
        MatcherAssert.assertThat((Object)plan.identifiers(), (Matcher)Matchers.equalTo(Collections.emptyList()));
        List children = plan.children();
        MatcherAssert.assertThat((Object)children.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Plan)children.get(0)).operatorType(), (Matcher)Matchers.equalTo((Object)"Y"));
    }
}

