/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.summary.InternalProfiledPlan;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.summary.ProfiledPlan;

class InternalProfiledPlanTest {
    InternalProfiledPlanTest() {
    }

    @Test
    void shouldHandlePlanWithNoChildren() {
        MapValue value = new MapValue(this.createPlanMap());
        ProfiledPlan plan = (ProfiledPlan)InternalProfiledPlan.PROFILED_PLAN_FROM_VALUE.apply(value);
        this.verifyPlan(plan);
    }

    @Test
    void shouldHandlePlanWithChildren() {
        Map<String, Value> planMap = this.createPlanMap();
        planMap.put("children", (Value)new ListValue(new Value[]{new MapValue(this.createPlanMap()), new MapValue(this.createPlanMap())}));
        MapValue value = new MapValue(planMap);
        ProfiledPlan plan = (ProfiledPlan)InternalProfiledPlan.PROFILED_PLAN_FROM_VALUE.apply(value);
        for (ProfiledPlan child : plan.children()) {
            this.verifyPlan(child);
        }
    }

    private Map<String, Value> createPlanMap() {
        HashMap<String, Value> map = new HashMap<String, Value>();
        map.put("operatorType", (Value)new StringValue("AwesomeOperator"));
        map.put("rows", (Value)new IntegerValue(1337L));
        map.put("dbHits", (Value)new IntegerValue(42L));
        map.put("pageCacheHits", (Value)new IntegerValue(1234L));
        map.put("pageCacheMisses", (Value)new IntegerValue(3456L));
        map.put("pageCacheHitRatio", (Value)new FloatValue(0.123));
        map.put("time", (Value)new IntegerValue(999L));
        map.put("identifiers", (Value)new ListValue(new Value[]{new StringValue("n1"), new StringValue("n2")}));
        HashMap<String, StringValue> args = new HashMap<String, StringValue>();
        args.put("version", new StringValue("CYPHER 1337"));
        map.put("args", (Value)new MapValue(args));
        return map;
    }

    private void verifyPlan(ProfiledPlan plan) {
        MatcherAssert.assertThat((Object)plan.dbHits(), (Matcher)CoreMatchers.equalTo((Object)42L));
        MatcherAssert.assertThat((Object)plan.records(), (Matcher)CoreMatchers.equalTo((Object)1337L));
        Assertions.assertTrue((boolean)plan.hasPageCacheStats());
        MatcherAssert.assertThat((Object)plan.pageCacheHits(), (Matcher)CoreMatchers.equalTo((Object)1234L));
        MatcherAssert.assertThat((Object)plan.pageCacheMisses(), (Matcher)CoreMatchers.equalTo((Object)3456L));
        MatcherAssert.assertThat((Object)plan.pageCacheHitRatio(), (Matcher)CoreMatchers.equalTo((Object)0.123));
        MatcherAssert.assertThat((Object)plan.time(), (Matcher)CoreMatchers.equalTo((Object)999L));
        MatcherAssert.assertThat((Object)plan.operatorType(), (Matcher)CoreMatchers.equalTo((Object)"AwesomeOperator"));
        MatcherAssert.assertThat((Object)plan.identifiers(), (Matcher)CoreMatchers.equalTo(Arrays.asList("n1", "n2")));
        MatcherAssert.assertThat(plan.arguments().values(), (Matcher)CoreMatchers.hasItem((Object)new StringValue("CYPHER 1337")));
        MatcherAssert.assertThat((Object)plan.children(), (Matcher)Matchers.empty());
    }
}

