/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.util.Iterables;

public class BookmarkUtil {
    public static void assertBookmarkIsEmpty(Bookmark bookmark) {
        Assertions.assertNotNull((Object)bookmark);
        MatcherAssert.assertThat((Object)bookmark, (Matcher)IsInstanceOf.instanceOf(InternalBookmark.class));
        Assertions.assertTrue((boolean)((InternalBookmark)bookmark).isEmpty());
    }

    public static void assertBookmarkIsNotEmpty(Bookmark bookmark) {
        Assertions.assertNotNull((Object)bookmark);
        MatcherAssert.assertThat((Object)bookmark, (Matcher)IsInstanceOf.instanceOf(InternalBookmark.class));
        Assertions.assertFalse((boolean)((InternalBookmark)bookmark).isEmpty());
    }

    public static void assertBookmarkContainsSingleValue(Bookmark bookmark) {
        BookmarkUtil.assertBookmarkContainsSingleValue(bookmark, (Matcher<String>)Matchers.notNullValue(String.class));
    }

    public static void assertBookmarkContainsSingleValue(Bookmark bookmark, Matcher<String> matcher) {
        Assertions.assertNotNull((Object)bookmark);
        MatcherAssert.assertThat((Object)bookmark, (Matcher)IsInstanceOf.instanceOf(InternalBookmark.class));
        List values = Iterables.asList((Iterable)((InternalBookmark)bookmark).values());
        MatcherAssert.assertThat((Object)values.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat(values.get(0), matcher);
    }

    public static void assertBookmarkContainsValues(Bookmark bookmark, Matcher<Iterable<String>> matcher) {
        Assertions.assertNotNull((Object)bookmark);
        MatcherAssert.assertThat((Object)bookmark, (Matcher)IsInstanceOf.instanceOf(InternalBookmark.class));
        List values = Iterables.asList((Iterable)((InternalBookmark)bookmark).values());
        MatcherAssert.assertThat((Object)values, matcher);
    }

    public static void assertBookmarksContainsSingleUniqueValues(Bookmark ... bookmarks) {
        int count = bookmarks.length;
        HashSet bookmarkStrings = new HashSet();
        for (Bookmark bookmark : bookmarks) {
            BookmarkUtil.assertBookmarkContainsSingleValue(bookmark);
            List values = Iterables.asList((Iterable)((InternalBookmark)bookmark).values());
            bookmarkStrings.addAll(values);
        }
        Assertions.assertEquals((int)count, (int)bookmarkStrings.size());
    }
}

