/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.cluster.ClusterComposition;

public final class ClusterCompositionUtil {
    public static final long NEVER_EXPIRE = System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L);
    public static final BoltServerAddress A = new BoltServerAddress("192.168.100.100:11");
    public static final BoltServerAddress B = new BoltServerAddress("192.168.100.101:22");
    public static final BoltServerAddress C = new BoltServerAddress("192.168.100.102:33");
    public static final BoltServerAddress D = new BoltServerAddress("192.168.100.103:44");
    public static final BoltServerAddress E = new BoltServerAddress("192.168.100.104:55");
    public static final BoltServerAddress F = new BoltServerAddress("192.168.100.105:66");
    public static final List<BoltServerAddress> EMPTY = new ArrayList<BoltServerAddress>();

    private ClusterCompositionUtil() {
    }

    @SafeVarargs
    public static ClusterComposition createClusterComposition(List<BoltServerAddress> ... servers) {
        return ClusterCompositionUtil.createClusterComposition(NEVER_EXPIRE, servers);
    }

    @SafeVarargs
    public static ClusterComposition createClusterComposition(long expirationTimestamp, List<BoltServerAddress> ... servers) {
        LinkedHashSet<BoltServerAddress> routers = new LinkedHashSet<BoltServerAddress>();
        LinkedHashSet<BoltServerAddress> writers = new LinkedHashSet<BoltServerAddress>();
        LinkedHashSet<BoltServerAddress> readers = new LinkedHashSet<BoltServerAddress>();
        switch (servers.length) {
            case 3: {
                readers.addAll(servers[2]);
            }
            case 2: {
                writers.addAll(servers[1]);
            }
            case 1: {
                routers.addAll(servers[0]);
            }
        }
        return new ClusterComposition(expirationTimestamp, readers, writers, routers, null);
    }
}

