/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.ResponseMessageHandler;
import org.neo4j.driver.internal.messaging.response.FailureMessage;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.packstream.PackOutput;

public class FailingMessageFormat
implements MessageFormat {
    private final MessageFormat delegate;
    private final AtomicReference<Throwable> writerThrowableRef = new AtomicReference();
    private final AtomicReference<Throwable> readerThrowableRef = new AtomicReference();
    private final AtomicReference<FailureMessage> readerFailureRef = new AtomicReference();

    public FailingMessageFormat(MessageFormat delegate) {
        this.delegate = delegate;
    }

    public void makeWriterThrow(Throwable error) {
        this.writerThrowableRef.set(error);
    }

    public void makeReaderThrow(Throwable error) {
        this.readerThrowableRef.set(error);
    }

    public void makeReaderFail(FailureMessage failureMsg) {
        this.readerFailureRef.set(failureMsg);
    }

    public MessageFormat.Writer newWriter(PackOutput output) {
        return new ThrowingWriter(this.delegate.newWriter(output), this.writerThrowableRef);
    }

    public MessageFormat.Reader newReader(PackInput input) {
        return new ThrowingReader(this.delegate.newReader(input), this.readerThrowableRef, this.readerFailureRef);
    }

    private static class ThrowingReader
    implements MessageFormat.Reader {
        final MessageFormat.Reader delegate;
        final AtomicReference<Throwable> throwableRef;
        final AtomicReference<FailureMessage> failureRef;

        ThrowingReader(MessageFormat.Reader delegate, AtomicReference<Throwable> throwableRef, AtomicReference<FailureMessage> failureRef) {
            this.delegate = delegate;
            this.throwableRef = throwableRef;
            this.failureRef = failureRef;
        }

        public void read(ResponseMessageHandler handler) throws IOException {
            Throwable error = this.throwableRef.getAndSet(null);
            if (error != null) {
                PlatformDependent.throwException((Throwable)error);
                return;
            }
            FailureMessage failureMsg = this.failureRef.getAndSet(null);
            if (failureMsg != null) {
                handler.handleFailureMessage(failureMsg.code(), failureMsg.message());
                return;
            }
            this.delegate.read(handler);
        }
    }

    private static class ThrowingWriter
    implements MessageFormat.Writer {
        final MessageFormat.Writer delegate;
        final AtomicReference<Throwable> throwableRef;

        ThrowingWriter(MessageFormat.Writer delegate, AtomicReference<Throwable> throwableRef) {
            this.delegate = delegate;
            this.throwableRef = throwableRef;
        }

        public void write(Message msg) throws IOException {
            Throwable error = this.throwableRef.getAndSet(null);
            if (error != null) {
                PlatformDependent.throwException((Throwable)error);
            } else {
                this.delegate.write(msg);
            }
        }
    }
}

