/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.driver.internal.util.Clock;

public class FakeClock
implements Clock {
    private final AtomicLong timestamp = new AtomicLong();
    private final PriorityBlockingQueue<WaitingThread> threads;

    public FakeClock() {
        this(false);
    }

    private FakeClock(boolean progressOnSleep) {
        this.threads = progressOnSleep ? null : new PriorityBlockingQueue();
    }

    public long millis() {
        return this.timestamp.get();
    }

    public void sleep(long millis) {
        if (millis <= 0L) {
            return;
        }
        long target = this.timestamp.get() + millis;
        if (this.threads != null) {
            WaitingThread token = new WaitingThread(Thread.currentThread(), target);
            this.threads.add(token);
            while (true) {
                if (this.timestamp.get() >= target) {
                    this.threads.remove(token);
                    return;
                }
                LockSupport.parkNanos(this, TimeUnit.MILLISECONDS.toNanos(millis));
            }
        }
        this.progress(millis);
    }

    public void progress(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("time can only progress forwards");
        }
        this.timestamp.addAndGet(millis);
        if (this.threads != null) {
            WaitingThread thread;
            while ((thread = this.threads.peek()) != null) {
                if (thread.timestamp >= this.timestamp.get()) continue;
                this.threads.remove(thread);
                LockSupport.unpark(thread.thread);
            }
        }
    }

    private static class WaitingThread {
        final Thread thread;
        final long timestamp;

        private WaitingThread(Thread thread, long timestamp) {
            this.thread = thread;
            this.timestamp = timestamp;
        }
    }
}

