/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.SucceededFuture;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.async.connection.EventLoopGroupFactory;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.Matchers;
import org.neo4j.driver.util.DaemonThreadFactory;
import org.neo4j.driver.util.TestUtil;

class FuturesTest {
    FuturesTest() {
    }

    @Test
    void shouldConvertCanceledNettyFutureToCompletionStage() throws Exception {
        DefaultPromise promise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        promise.cancel(true);
        CompletableFuture future = Futures.asCompletionStage((Future)promise).toCompletableFuture();
        Assertions.assertTrue((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        Assertions.assertThrows(CancellationException.class, future::get);
    }

    @Test
    void shouldConvertSucceededNettyFutureToCompletionStage() throws Exception {
        SucceededFuture nettyFuture = new SucceededFuture((EventExecutor)ImmediateEventExecutor.INSTANCE, (Object)"Hello");
        CompletableFuture future = Futures.asCompletionStage((Future)nettyFuture).toCompletableFuture();
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
        Assertions.assertEquals((Object)"Hello", future.get());
    }

    @Test
    void shouldConvertFailedNettyFutureToCompletionStage() throws Exception {
        RuntimeException error = new RuntimeException("Hello");
        FailedFuture nettyFuture = new FailedFuture((EventExecutor)ImmediateEventExecutor.INSTANCE, (Throwable)error);
        CompletableFuture future = Futures.asCompletionStage((Future)nettyFuture).toCompletableFuture();
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
        Assertions.assertEquals((Object)error, (Object)e.getCause());
    }

    @Test
    void shouldConvertRunningNettyFutureToCompletionStageWhenFutureCanceled() throws Exception {
        DefaultPromise promise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        CompletableFuture future = Futures.asCompletionStage((Future)promise).toCompletableFuture();
        Assertions.assertFalse((boolean)future.isDone());
        promise.cancel(true);
        Assertions.assertTrue((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        Assertions.assertThrows(CancellationException.class, future::get);
    }

    @Test
    void shouldConvertRunningNettyFutureToCompletionStageWhenFutureSucceeded() throws Exception {
        DefaultPromise promise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        CompletableFuture future = Futures.asCompletionStage((Future)promise).toCompletableFuture();
        Assertions.assertFalse((boolean)future.isDone());
        promise.setSuccess((Object)"Hello");
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
        Assertions.assertEquals((Object)"Hello", future.get());
    }

    @Test
    void shouldConvertRunningNettyFutureToCompletionStageWhenFutureFailed() throws Exception {
        RuntimeException error = new RuntimeException("Hello");
        DefaultPromise promise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        CompletableFuture future = Futures.asCompletionStage((Future)promise).toCompletableFuture();
        Assertions.assertFalse((boolean)future.isDone());
        promise.setFailure((Throwable)error);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
        Assertions.assertEquals((Object)error, (Object)e.getCause());
    }

    @Test
    void shouldCreateFailedFutureWithUncheckedException() throws Exception {
        RuntimeException error = new RuntimeException("Hello");
        CompletableFuture future = Futures.failedFuture((Throwable)error).toCompletableFuture();
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
        Assertions.assertEquals((Object)error, (Object)e.getCause());
    }

    @Test
    void shouldCreateFailedFutureWithCheckedException() throws Exception {
        IOException error = new IOException("Hello");
        CompletableFuture future = Futures.failedFuture((Throwable)error).toCompletableFuture();
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
        Assertions.assertEquals((Object)error, (Object)e.getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldFailBlockingGetInEventLoopThread() throws Exception {
        EventLoopGroup eventExecutor = EventLoopGroupFactory.newEventLoopGroup((int)1);
        try {
            CompletableFuture future = new CompletableFuture();
            Future result = eventExecutor.submit(() -> (String)Futures.blockingGet((CompletionStage)future));
            ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> result.get());
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)org.hamcrest.Matchers.is(Matchers.blockingOperationInEventLoopError()));
        }
        finally {
            eventExecutor.shutdownGracefully();
        }
    }

    @Test
    void shouldThrowInBlockingGetWhenFutureThrowsUncheckedException() {
        RuntimeException error = new RuntimeException("Hello");
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(error);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            String cfr_ignored_0 = (String)Futures.blockingGet((CompletionStage)future);
        });
        Assertions.assertEquals((Object)error, (Object)e);
    }

    @Test
    void shouldThrowInBlockingGetWhenFutureThrowsCheckedException() {
        IOException error = new IOException("Hello");
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(error);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            String cfr_ignored_0 = (String)Futures.blockingGet((CompletionStage)future);
        });
        Assertions.assertEquals((Object)error, (Object)e);
    }

    @Test
    void shouldReturnFromBlockingGetWhenFutureCompletes() {
        CompletableFuture<String> future = new CompletableFuture<String>();
        future.complete("Hello");
        Assertions.assertEquals((Object)"Hello", (Object)Futures.blockingGet(future));
    }

    @Test
    void shouldWaitForFutureInBlockingGetEvenWhenInterrupted() {
        ExecutorService executor = Executors.newSingleThreadExecutor(DaemonThreadFactory.daemon("InterruptThread"));
        try {
            CompletableFuture future = new CompletableFuture();
            Thread.currentThread().interrupt();
            executor.submit(() -> {
                TestUtil.sleep(1000);
                future.complete("Hello");
            });
            Assertions.assertEquals((Object)"Hello", (Object)Futures.blockingGet(future));
            Assertions.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
            executor.shutdown();
        }
    }

    @Test
    void shouldHandleInterruptsInBlockingGet() {
        try {
            CompletableFuture future = new CompletableFuture();
            Thread.currentThread().interrupt();
            Runnable interruptHandler = () -> future.complete("Hello");
            Assertions.assertEquals((Object)"Hello", (Object)Futures.blockingGet(future, (Runnable)interruptHandler));
            Assertions.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    @Test
    void shouldGetNowWhenFutureDone() {
        CompletableFuture<String> future = new CompletableFuture<String>();
        future.complete("Hello");
        Assertions.assertEquals((Object)"Hello", (Object)Futures.getNow(future));
    }

    @Test
    void shouldGetNowWhenFutureNotDone() {
        CompletableFuture future = new CompletableFuture();
        Assertions.assertNull((Object)Futures.getNow(future));
    }

    @Test
    void shouldGetCauseFromCompletionException() {
        RuntimeException error = new RuntimeException("Hello");
        CompletionException completionException = new CompletionException(error);
        Assertions.assertEquals((Object)error, (Object)Futures.completionExceptionCause((Throwable)completionException));
    }

    @Test
    void shouldReturnSameExceptionWhenItIsNotCompletionException() {
        RuntimeException error = new RuntimeException("Hello");
        Assertions.assertEquals((Object)error, (Object)Futures.completionExceptionCause((Throwable)error));
    }

    @Test
    void shouldWrapWithCompletionException() {
        RuntimeException error = new RuntimeException("Hello");
        CompletionException completionException = Futures.asCompletionException((Throwable)error);
        Assertions.assertEquals((Object)error, (Object)completionException.getCause());
    }

    @Test
    void shouldKeepCompletionExceptionAsIs() {
        CompletionException error = new CompletionException(new RuntimeException("Hello"));
        Assertions.assertEquals((Object)error, (Object)Futures.asCompletionException((Throwable)error));
    }

    @Test
    void shouldCombineTwoErrors() {
        RuntimeException error1 = new RuntimeException("Error1");
        RuntimeException error2Cause = new RuntimeException("Error2");
        CompletionException error2 = new CompletionException(error2Cause);
        CompletionException combined = Futures.combineErrors((Throwable)error1, (Throwable)error2);
        Assertions.assertEquals((Object)error1, (Object)combined.getCause());
        Assertions.assertArrayEquals((Object[])new Throwable[]{error2Cause}, (Object[])combined.getCause().getSuppressed());
    }

    @Test
    void shouldCombineErrorAndNull() {
        RuntimeException error1 = new RuntimeException("Error1");
        CompletionException combined = Futures.combineErrors((Throwable)error1, null);
        Assertions.assertEquals((Object)error1, (Object)combined.getCause());
    }

    @Test
    void shouldCombineNullAndError() {
        RuntimeException error2 = new RuntimeException("Error2");
        CompletionException combined = Futures.combineErrors(null, (Throwable)error2);
        Assertions.assertEquals((Object)error2, (Object)combined.getCause());
    }

    @Test
    void shouldCombineNullAndNullErrors() {
        Assertions.assertNull((Object)Futures.combineErrors(null, null));
    }
}

