/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;

public abstract class MatcherFactory<T>
implements SelfDescribing {
    public abstract Matcher<T> createMatcher();

    public static <T> Matcher<? extends Iterable<T>> count(final Matcher<T> matcher, final Matcher<Integer> count) {
        return new TypeSafeDiagnosingMatcher<Iterable<T>>(){

            protected boolean matchesSafely(Iterable<T> collection, Description mismatchDescription) {
                int matches = 0;
                for (Object item : collection) {
                    if (!matcher.matches(item)) continue;
                    ++matches;
                }
                if (count.matches((Object)matches)) {
                    return true;
                }
                mismatchDescription.appendText("actual number of matches was ").appendValue((Object)matches).appendText(" in ").appendValue(collection);
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("collection containing ").appendDescriptionOf((SelfDescribing)count).appendText(" occurences of ").appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }

    @SafeVarargs
    public static <T> Matcher<? extends Iterable<T>> containsAtLeast(Matcher<T> ... matchers) {
        MatcherFactory[] factories = new MatcherFactory[matchers.length];
        for (int i = 0; i < factories.length; ++i) {
            factories[i] = MatcherFactory.matches(matchers[i]);
        }
        return MatcherFactory.containsAtLeast(factories);
    }

    @SafeVarargs
    public static <T> Matcher<? extends Iterable<T>> containsAtLeast(final MatcherFactory<T> ... matcherFactories) {
        return new TypeSafeMatcher<Iterable<T>>(){

            protected boolean matchesSafely(Iterable<T> collection) {
                int i;
                Matcher[] matchers = new Matcher[matcherFactories.length];
                for (i = 0; i < matchers.length; ++i) {
                    matchers[i] = matcherFactories[i].createMatcher();
                }
                i = 0;
                for (Object item : collection) {
                    if (i >= matchers.length) {
                        return true;
                    }
                    if (!matchers[i].matches(item)) continue;
                    ++i;
                }
                return i == matchers.length;
            }

            public void describeTo(Description description) {
                description.appendText("collection containing at least ");
                for (int i = 0; i < matcherFactories.length; ++i) {
                    if (i != 0) {
                        if (i == matcherFactories.length - 1) {
                            description.appendText(" and ");
                        } else {
                            description.appendText(", ");
                        }
                    }
                    description.appendDescriptionOf((SelfDescribing)matcherFactories[i]);
                }
                description.appendText(" (in that order) ");
            }
        };
    }

    @SafeVarargs
    public static <T> MatcherFactory<T> inAnyOrder(final Matcher<? extends T> ... matchers) {
        return new MatcherFactory<T>(){

            @Override
            public Matcher<T> createMatcher() {
                final ArrayList remaining = new ArrayList(matchers.length);
                Collections.addAll(remaining, matchers);
                return new BaseMatcher<T>(){

                    public boolean matches(Object item) {
                        Iterator matcher = remaining.iterator();
                        while (matcher.hasNext()) {
                            if (!((Matcher)matcher.next()).matches(item)) continue;
                            matcher.remove();
                            return remaining.isEmpty();
                        }
                        return remaining.isEmpty();
                    }

                    public void describeTo(Description description) {
                        this.describe(description);
                    }
                };
            }

            public void describeTo(Description description) {
                this.describe(description);
            }

            private void describe(Description description) {
                description.appendText("in any order");
                String sep = " {";
                for (Matcher matcher : matchers) {
                    description.appendText(sep);
                    description.appendDescriptionOf((SelfDescribing)matcher);
                    sep = ", ";
                }
                description.appendText("}");
            }
        };
    }

    public static <T> MatcherFactory<T> matches(final Matcher<T> matcher) {
        return new MatcherFactory<T>(){

            @Override
            public Matcher<T> createMatcher() {
                return matcher;
            }

            public void describeTo(Description description) {
                matcher.describeTo(description);
            }
        };
    }
}

