/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.time.Duration;
import java.time.Period;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.util.Preconditions;

class PreconditionsTest {
    PreconditionsTest() {
    }

    @Test
    void shouldCheckBooleanArgument() {
        Assertions.assertDoesNotThrow(() -> Preconditions.checkArgument((boolean)true, (String)""));
        Assertions.assertDoesNotThrow(() -> Preconditions.checkArgument((!Duration.ofSeconds(1L).isZero() ? 1 : 0) != 0, (String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.checkArgument((boolean)false, (String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.checkArgument((boolean)Period.ofDays(2).isNegative(), (String)""));
    }

    @Test
    void shouldCheckArgumentType() {
        Assertions.assertDoesNotThrow(() -> Preconditions.checkArgument((Object)"Hello", String.class));
        Assertions.assertDoesNotThrow(() -> Preconditions.checkArgument(new ArrayList(), List.class));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.checkArgument((Object)42, String.class));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.checkArgument(new ArrayList(), Map.class));
    }
}

