/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.messaging.v41.BoltProtocolV41;
import org.neo4j.driver.internal.messaging.v42.BoltProtocolV42;
import org.neo4j.driver.internal.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.messaging.v44.BoltProtocolV44;
import org.neo4j.driver.internal.util.ServerVersion;

class ServerVersionTest {
    ServerVersionTest() {
    }

    @Test
    void version() {
        MatcherAssert.assertThat((Object)ServerVersion.version((String)"Neo4j/dev"), (Matcher)Matchers.is((Object)ServerVersion.vInDev));
        MatcherAssert.assertThat((Object)ServerVersion.version((String)"Neo4j/4.0.0"), (Matcher)Matchers.is((Object)ServerVersion.v4_0_0));
    }

    @Test
    void shouldHaveCorrectToString() {
        Assertions.assertEquals((Object)"Neo4j/dev", (Object)ServerVersion.vInDev.toString());
        Assertions.assertEquals((Object)"Neo4j/4.0.0", (Object)ServerVersion.v4_0_0.toString());
        Assertions.assertEquals((Object)"Neo4j/3.5.0", (Object)ServerVersion.v3_5_0.toString());
        Assertions.assertEquals((Object)"Neo4j/3.5.7", (Object)ServerVersion.version((String)"Neo4j/3.5.7").toString());
    }

    @Test
    void shouldFailToParseIllegalVersions() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ServerVersion.version((String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ServerVersion.version((String)"/1.2.3"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ServerVersion.version((String)"Neo4j1.2.3"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ServerVersion.version((String)"Neo4j"));
    }

    @Test
    void shouldFailToCompareDifferentProducts() {
        ServerVersion version1 = ServerVersion.version((String)"MyNeo4j/1.2.3");
        ServerVersion version2 = ServerVersion.version((String)"OtherNeo4j/1.2.4");
        Assertions.assertThrows(IllegalArgumentException.class, () -> version1.greaterThanOrEqual(version2));
    }

    @Test
    void shouldReturnCorrectServerVersionFromBoltProtocolVersion() {
        Assertions.assertEquals((Object)ServerVersion.v4_0_0, (Object)ServerVersion.fromBoltProtocolVersion((BoltProtocolVersion)BoltProtocolV4.VERSION));
        Assertions.assertEquals((Object)ServerVersion.v4_1_0, (Object)ServerVersion.fromBoltProtocolVersion((BoltProtocolVersion)BoltProtocolV41.VERSION));
        Assertions.assertEquals((Object)ServerVersion.v4_2_0, (Object)ServerVersion.fromBoltProtocolVersion((BoltProtocolVersion)BoltProtocolV42.VERSION));
        Assertions.assertEquals((Object)ServerVersion.v4_3_0, (Object)ServerVersion.fromBoltProtocolVersion((BoltProtocolVersion)BoltProtocolV43.VERSION));
        Assertions.assertEquals((Object)ServerVersion.v4_4_0, (Object)ServerVersion.fromBoltProtocolVersion((BoltProtocolVersion)BoltProtocolV44.VERSION));
        Assertions.assertEquals((Object)ServerVersion.vInDev, (Object)ServerVersion.fromBoltProtocolVersion((BoltProtocolVersion)new BoltProtocolVersion(Integer.MAX_VALUE, Integer.MAX_VALUE)));
    }
}

