/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.time.LocalDate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.DateValue;

class DateValueTest {
    DateValueTest() {
    }

    @Test
    void shouldHaveCorrectType() {
        LocalDate localDate = LocalDate.now();
        DateValue dateValue = new DateValue(localDate);
        Assertions.assertEquals((Object)InternalTypeSystem.TYPE_SYSTEM.DATE(), (Object)dateValue.type());
    }

    @Test
    void shouldSupportAsObject() {
        LocalDate localDate = LocalDate.now();
        DateValue dateValue = new DateValue(localDate);
        Assertions.assertEquals((Object)localDate, (Object)dateValue.asObject());
    }

    @Test
    void shouldSupportAsLocalDate() {
        LocalDate localDate = LocalDate.now();
        DateValue dateValue = new DateValue(localDate);
        Assertions.assertEquals((Object)localDate, (Object)dateValue.asLocalDate());
    }

    @Test
    void shouldNotSupportAsLong() {
        LocalDate localDate = LocalDate.now();
        DateValue dateValue = new DateValue(localDate);
        Assertions.assertThrows(Uncoercible.class, () -> ((DateValue)dateValue).asLong());
    }
}

