/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.value.LossyCoercion;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.types.TypeSystem;

class FloatValueTest {
    private TypeSystem typeSystem = InternalTypeSystem.TYPE_SYSTEM;

    FloatValueTest() {
    }

    @Test
    void testZeroFloatValue() {
        FloatValue value = new FloatValue(0.0);
        MatcherAssert.assertThat((Object)value.asInt(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)value.asLong(), (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)Float.valueOf(value.asFloat()), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((Object)value.asDouble(), (Matcher)CoreMatchers.equalTo((Object)0.0));
    }

    @Test
    void testNonZeroFloatValue() {
        FloatValue value = new FloatValue(6.28);
        MatcherAssert.assertThat((Object)value.asDouble(), (Matcher)CoreMatchers.equalTo((Object)6.28));
    }

    @Test
    void testIsFloat() {
        FloatValue value = new FloatValue(6.28);
        MatcherAssert.assertThat((Object)this.typeSystem.FLOAT().isTypeOf((Value)value), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    void testEquals() {
        FloatValue firstValue = new FloatValue(6.28);
        FloatValue secondValue = new FloatValue(6.28);
        MatcherAssert.assertThat((Object)firstValue, (Matcher)CoreMatchers.equalTo((Object)secondValue));
    }

    @Test
    void testHashCode() {
        FloatValue value = new FloatValue(6.28);
        MatcherAssert.assertThat((Object)value.hashCode(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    void shouldNotBeNull() {
        FloatValue value = new FloatValue(6.28);
        Assertions.assertFalse((boolean)value.isNull());
    }

    @Test
    void shouldTypeAsFloat() {
        FloatValue value = new FloatValue(6.28);
        MatcherAssert.assertThat((Object)value.typeConstructor(), (Matcher)CoreMatchers.equalTo((Object)TypeConstructor.FLOAT));
    }

    @Test
    void shouldThrowIfFloatContainsDecimalWhenConverting() {
        FloatValue value = new FloatValue(1.1);
        Assertions.assertThrows(LossyCoercion.class, () -> ((FloatValue)value).asInt());
    }

    @Test
    void shouldThrowIfLargerThanIntegerMax() {
        FloatValue value1 = new FloatValue(2.147483647E9);
        FloatValue value2 = new FloatValue(2.147483648E9);
        MatcherAssert.assertThat((Object)value1.asInt(), (Matcher)CoreMatchers.equalTo((Object)Integer.MAX_VALUE));
        Assertions.assertThrows(LossyCoercion.class, () -> ((FloatValue)value2).asInt());
    }

    @Test
    void shouldThrowIfSmallerThanIntegerMin() {
        FloatValue value1 = new FloatValue(-2.147483648E9);
        FloatValue value2 = new FloatValue(-2.147483649E9);
        MatcherAssert.assertThat((Object)value1.asInt(), (Matcher)CoreMatchers.equalTo((Object)Integer.MIN_VALUE));
        Assertions.assertThrows(LossyCoercion.class, () -> ((FloatValue)value2).asInt());
    }
}

