/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.value.LossyCoercion;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.types.TypeSystem;

class IntegerValueTest {
    private TypeSystem typeSystem = InternalTypeSystem.TYPE_SYSTEM;

    IntegerValueTest() {
    }

    @Test
    void testZeroIntegerValue() {
        IntegerValue value = new IntegerValue(0L);
        MatcherAssert.assertThat((Object)value.asLong(), (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)value.asInt(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)value.asDouble(), (Matcher)CoreMatchers.equalTo((Object)0.0));
        MatcherAssert.assertThat((Object)Float.valueOf(value.asFloat()), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((Object)value.asNumber(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    void testNonZeroIntegerValue() {
        IntegerValue value = new IntegerValue(1L);
        MatcherAssert.assertThat((Object)value.asLong(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)value.asInt(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)value.asDouble(), (Matcher)CoreMatchers.equalTo((Object)1.0));
        MatcherAssert.assertThat((Object)Float.valueOf(value.asFloat()), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((Object)value.asNumber(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    void testIsInteger() {
        IntegerValue value = new IntegerValue(1L);
        MatcherAssert.assertThat((Object)this.typeSystem.INTEGER().isTypeOf((Value)value), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    void testEquals() {
        IntegerValue firstValue = new IntegerValue(1L);
        IntegerValue secondValue = new IntegerValue(1L);
        MatcherAssert.assertThat((Object)firstValue, (Matcher)CoreMatchers.equalTo((Object)secondValue));
    }

    @Test
    void testHashCode() {
        IntegerValue value = new IntegerValue(1L);
        MatcherAssert.assertThat((Object)value.hashCode(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    void shouldNotBeNull() {
        IntegerValue value = new IntegerValue(1L);
        Assertions.assertFalse((boolean)value.isNull());
    }

    @Test
    void shouldTypeAsInteger() {
        IntegerValue value = new IntegerValue(1L);
        MatcherAssert.assertThat((Object)value.typeConstructor(), (Matcher)CoreMatchers.equalTo((Object)TypeConstructor.INTEGER));
    }

    @Test
    void shouldThrowIfLargerThanIntegerMax() {
        IntegerValue value1 = new IntegerValue(Integer.MAX_VALUE);
        IntegerValue value2 = new IntegerValue(0x80000000L);
        MatcherAssert.assertThat((Object)value1.asInt(), (Matcher)CoreMatchers.equalTo((Object)Integer.MAX_VALUE));
        Assertions.assertThrows(LossyCoercion.class, () -> ((IntegerValue)value2).asInt());
    }

    @Test
    void shouldThrowIfSmallerThanIntegerMin() {
        IntegerValue value1 = new IntegerValue(Integer.MIN_VALUE);
        IntegerValue value2 = new IntegerValue(-2147483649L);
        MatcherAssert.assertThat((Object)value1.asInt(), (Matcher)CoreMatchers.equalTo((Object)Integer.MIN_VALUE));
        Assertions.assertThrows(LossyCoercion.class, () -> ((IntegerValue)value2).asInt());
    }

    @Test
    void shouldThrowIfLargerThan() {
        IntegerValue value1 = new IntegerValue(0x20000000000000L);
        IntegerValue value2 = new IntegerValue(0x20000000000001L);
        MatcherAssert.assertThat((Object)value1.asDouble(), (Matcher)CoreMatchers.equalTo((Object)9.007199254740992E15));
        Assertions.assertThrows(LossyCoercion.class, () -> ((IntegerValue)value2).asDouble());
    }
}

