/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ListValue;

class ListValueTest {
    ListValueTest() {
    }

    @Test
    void shouldHaveSensibleToString() {
        ListValue listValue = this.listValue(Values.value((int)1), Values.value((int)2), Values.value((int)3));
        MatcherAssert.assertThat((Object)listValue.toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3]"));
    }

    @Test
    void shouldHaveCorrectType() {
        ListValue listValue = this.listValue(new Value[0]);
        MatcherAssert.assertThat((Object)listValue.type(), (Matcher)CoreMatchers.equalTo((Object)InternalTypeSystem.TYPE_SYSTEM.LIST()));
    }

    private ListValue listValue(Value ... values) {
        return new ListValue(values);
    }
}

