/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.MapValue;

class MapValueTest {
    MapValueTest() {
    }

    @Test
    void shouldHaveSensibleToString() {
        MapValue mapValue = this.mapValue();
        MatcherAssert.assertThat((Object)mapValue.toString(), (Matcher)CoreMatchers.equalTo((Object)"{k1: \"v1\", k2: 42}"));
    }

    @Test
    void shouldHaveCorrectPropertyCount() {
        MapValue mapValue = this.mapValue();
        MatcherAssert.assertThat((Object)mapValue.size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    void shouldHaveCorrectType() {
        MapValue map = this.mapValue();
        MatcherAssert.assertThat((Object)map.type(), (Matcher)CoreMatchers.equalTo((Object)InternalTypeSystem.TYPE_SYSTEM.MAP()));
    }

    @Test
    void shouldNotBeNull() {
        MapValue map = this.mapValue();
        Assertions.assertFalse((boolean)map.isNull());
    }

    private MapValue mapValue() {
        HashMap<String, Value> map = new HashMap<String, Value>();
        map.put("k1", Values.value((String)"v1"));
        map.put("k2", Values.value((int)42));
        return new MapValue(map);
    }
}

