/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.util.ValueFactory;
import org.neo4j.driver.internal.value.RelationshipValue;

class RelationshipValueTest {
    RelationshipValueTest() {
    }

    @Test
    void shouldHaveSensibleToString() {
        Assertions.assertEquals((Object)"relationship<1234>", (Object)ValueFactory.emptyRelationshipValue().toString());
        Assertions.assertEquals((Object)"relationship<1234>", (Object)ValueFactory.filledRelationshipValue().toString());
    }

    @Test
    void shouldHaveCorrectPropertyCount() {
        Assertions.assertEquals((int)0, (int)ValueFactory.emptyRelationshipValue().size());
        Assertions.assertEquals((int)1, (int)ValueFactory.filledRelationshipValue().size());
    }

    @Test
    void shouldNotBeNull() {
        RelationshipValue value = ValueFactory.emptyRelationshipValue();
        Assertions.assertFalse((boolean)value.isNull());
    }

    @Test
    void shouldTypeAsRelationship() {
        RelationshipValue value = ValueFactory.emptyRelationshipValue();
        MatcherAssert.assertThat((Object)value.typeConstructor(), (Matcher)CoreMatchers.equalTo((Object)TypeConstructor.RELATIONSHIP));
    }
}

