/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.TimeValue;

class TimeValueTest {
    TimeValueTest() {
    }

    @Test
    void shouldHaveCorrectType() {
        OffsetTime time = OffsetTime.now().withOffsetSameInstant(ZoneOffset.ofHoursMinutes(5, 30));
        TimeValue timeValue = new TimeValue(time);
        Assertions.assertEquals((Object)InternalTypeSystem.TYPE_SYSTEM.TIME(), (Object)timeValue.type());
    }

    @Test
    void shouldSupportAsObject() {
        OffsetTime time = OffsetTime.of(19, 0, 10, 1, ZoneOffset.ofHours(-3));
        TimeValue timeValue = new TimeValue(time);
        Assertions.assertEquals((Object)time, (Object)timeValue.asObject());
    }

    @Test
    void shouldSupportAsOffsetTime() {
        OffsetTime time = OffsetTime.of(23, 59, 59, 999999999, ZoneOffset.ofHoursMinutes(2, 15));
        TimeValue timeValue = new TimeValue(time);
        Assertions.assertEquals((Object)time, (Object)timeValue.asOffsetTime());
    }

    @Test
    void shouldNotSupportAsLong() {
        OffsetTime time = OffsetTime.now().withOffsetSameInstant(ZoneOffset.ofHours(-5));
        TimeValue timeValue = new TimeValue(time);
        Assertions.assertThrows(Uncoercible.class, () -> ((TimeValue)timeValue).asLong());
    }
}

