/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.logging.DevNullLogger;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.reactive.RxTransaction;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.AsyncCommand;
import org.neo4j.driver.stress.AsyncFailingQueryWithRetries;
import org.neo4j.driver.stress.AsyncReadQueryWithRetries;
import org.neo4j.driver.stress.AsyncWriteQueryWithRetries;
import org.neo4j.driver.stress.AsyncWrongQueryWithRetries;
import org.neo4j.driver.stress.BlockingCommand;
import org.neo4j.driver.stress.BlockingFailingQueryWithRetries;
import org.neo4j.driver.stress.BlockingReadQueryWithRetries;
import org.neo4j.driver.stress.BlockingWriteQueryWithRetries;
import org.neo4j.driver.stress.BlockingWrongQueryWithRetries;
import org.neo4j.driver.stress.FailedAuth;
import org.neo4j.driver.stress.RxCommand;
import org.neo4j.driver.stress.RxFailingQueryWithRetries;
import org.neo4j.driver.stress.RxReadQueryWithRetries;
import org.neo4j.driver.stress.RxWriteQueryWithRetries;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.util.DaemonThreadFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

abstract class AbstractStressTestBase<C extends AbstractContext> {
    private static final int THREAD_COUNT = Integer.getInteger("threadCount", 8);
    private static final int ASYNC_BATCH_SIZE = Integer.getInteger("asyncBatchSize", 10);
    private static final int EXECUTION_TIME_SECONDS = Integer.getInteger("executionTimeSeconds", 20);
    private static final boolean DEBUG_LOGGING_ENABLED = Boolean.getBoolean("loggingEnabled");
    private static final int BIG_DATA_TEST_NODE_COUNT = Integer.getInteger("bigDataTestNodeCount", 30000);
    private static final int BIG_DATA_TEST_BATCH_SIZE = Integer.getInteger("bigDataTestBatchSize", 10000);
    private LoggerNameTrackingLogging logging;
    private ExecutorService executor;
    InternalDriver driver;

    AbstractStressTestBase() {
    }

    @BeforeEach
    void setUp() {
        this.logging = new LoggerNameTrackingLogging();
        this.driver = (InternalDriver)GraphDatabase.driver((URI)this.databaseUri(), (AuthToken)this.authToken(), (Config)this.config());
        DaemonThreadFactory threadFactory = new DaemonThreadFactory(this.getClass().getSimpleName() + "-worker-");
        this.executor = Executors.newCachedThreadPool(threadFactory);
    }

    @AfterEach
    void tearDown() {
        this.executor.shutdownNow();
        if (this.driver != null) {
            this.driver.close();
        }
    }

    @Test
    void blockingApiStressTest() throws Throwable {
        this.runStressTest(this::launchBlockingWorkerThreads);
    }

    @Test
    void asyncApiStressTest() throws Throwable {
        this.runStressTest(this::launchAsyncWorkerThreads);
    }

    @Test
    void rxApiStressTest() throws Throwable {
        this.assertRxIsAvailable();
        this.runStressTest(this::launchRxWorkerThreads);
    }

    @Test
    void blockingApiBigDataTest() {
        Bookmark bookmark = AbstractStressTestBase.createNodesBlocking(AbstractStressTestBase.bigDataTestBatchCount(), BIG_DATA_TEST_BATCH_SIZE, (Driver)this.driver);
        AbstractStressTestBase.readNodesBlocking((Driver)this.driver, bookmark, BIG_DATA_TEST_NODE_COUNT);
    }

    @Test
    void asyncApiBigDataTest() throws Throwable {
        Bookmark bookmark = AbstractStressTestBase.createNodesAsync(AbstractStressTestBase.bigDataTestBatchCount(), BIG_DATA_TEST_BATCH_SIZE, (Driver)this.driver);
        AbstractStressTestBase.readNodesAsync((Driver)this.driver, bookmark, BIG_DATA_TEST_NODE_COUNT);
    }

    @Test
    void rxApiBigDataTest() {
        this.assertRxIsAvailable();
        Bookmark bookmark = this.createNodesRx(AbstractStressTestBase.bigDataTestBatchCount(), BIG_DATA_TEST_BATCH_SIZE, this.driver);
        this.readNodesRx(this.driver, bookmark, BIG_DATA_TEST_NODE_COUNT);
    }

    private void assertRxIsAvailable() {
        Assumptions.assumeTrue((boolean)this.driver.supportsMultiDb());
    }

    private void runStressTest(Function<C, List<Future<?>>> threadLauncher) throws Throwable {
        C context = this.createContext();
        List<Future<?>> resultFutures = threadLauncher.apply(context);
        ResourcesInfo resourcesInfo = this.sleepAndGetResourcesInfo();
        ((AbstractContext)context).stop();
        Throwable firstError = null;
        for (Future<?> future : resultFutures) {
            try {
                Assertions.assertNull(future.get(10L, TimeUnit.SECONDS));
            }
            catch (Throwable error) {
                firstError = AbstractStressTestBase.withSuppressed(firstError, error);
            }
        }
        this.printStats(context);
        if (firstError != null) {
            throw firstError;
        }
        this.verifyResults(context, resourcesInfo);
    }

    abstract URI databaseUri();

    abstract AuthToken authToken();

    abstract Config.ConfigBuilder config(Config.ConfigBuilder var1);

    Config config() {
        Config.ConfigBuilder builder = Config.builder().withLogging((Logging)this.logging).withMaxConnectionPoolSize(100).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES);
        return this.config(builder).build();
    }

    abstract C createContext();

    List<BlockingCommand<C>> createTestSpecificBlockingCommands() {
        return Collections.emptyList();
    }

    List<AsyncCommand<C>> createTestSpecificAsyncCommands() {
        return Collections.emptyList();
    }

    List<RxCommand<C>> createTestSpecificRxCommands() {
        return Collections.emptyList();
    }

    abstract boolean handleWriteFailure(Throwable var1, C var2);

    abstract <A extends C> void printStats(A var1);

    private List<Future<?>> launchBlockingWorkerThreads(C context) {
        List<BlockingCommand<C>> commands = this.createBlockingCommands();
        ArrayList futures = new ArrayList();
        for (int i = 0; i < THREAD_COUNT; ++i) {
            Future<Void> future = this.launchBlockingWorkerThread(this.executor, commands, context);
            futures.add(future);
        }
        return futures;
    }

    private List<BlockingCommand<C>> createBlockingCommands() {
        ArrayList<BlockingCommand<C>> commands = new ArrayList<BlockingCommand<C>>();
        commands.add(new BlockingReadQueryWithRetries((Driver)this.driver, false));
        commands.add(new BlockingReadQueryWithRetries((Driver)this.driver, true));
        commands.add(new BlockingWriteQueryWithRetries(this, (Driver)this.driver, false));
        commands.add(new BlockingWriteQueryWithRetries(this, (Driver)this.driver, true));
        commands.add(new BlockingWrongQueryWithRetries((Driver)this.driver));
        commands.add(new BlockingFailingQueryWithRetries((Driver)this.driver));
        commands.add(new FailedAuth(this.databaseUri(), this.config()));
        commands.addAll(this.createTestSpecificBlockingCommands());
        return commands;
    }

    private Future<Void> launchBlockingWorkerThread(ExecutorService executor, List<BlockingCommand<C>> commands, C context) {
        return executor.submit(() -> {
            while (!context.isStopped()) {
                BlockingCommand command = (BlockingCommand)AbstractStressTestBase.randomOf(commands);
                command.execute(context);
            }
            return null;
        });
    }

    private List<Future<?>> launchRxWorkerThreads(C context) {
        List<RxCommand<C>> commands = this.createRxCommands();
        ArrayList futures = new ArrayList();
        for (int i = 0; i < THREAD_COUNT; ++i) {
            Future<Void> future = this.launchRxWorkerThread(this.executor, commands, context);
            futures.add(future);
        }
        return futures;
    }

    private List<RxCommand<C>> createRxCommands() {
        ArrayList<RxCommand<C>> commands = new ArrayList<RxCommand<C>>();
        commands.add(new RxReadQueryWithRetries((Driver)this.driver, false));
        commands.add(new RxReadQueryWithRetries((Driver)this.driver, true));
        commands.add(new RxWriteQueryWithRetries(this, (Driver)this.driver, false));
        commands.add(new RxWriteQueryWithRetries(this, (Driver)this.driver, true));
        commands.add(new RxFailingQueryWithRetries((Driver)this.driver));
        commands.addAll(this.createTestSpecificRxCommands());
        return commands;
    }

    private Future<Void> launchRxWorkerThread(ExecutorService executor, List<RxCommand<C>> commands, C context) {
        return executor.submit(() -> {
            while (!context.isStopped()) {
                CompletableFuture<Void> allCommands = this.executeRxCommands(context, commands, ASYNC_BATCH_SIZE);
                Assertions.assertNull((Object)allCommands.get());
            }
            return null;
        });
    }

    private CompletableFuture<Void> executeRxCommands(C context, List<RxCommand<C>> commands, int count) {
        CompletableFuture[] executions = new CompletableFuture[count];
        for (int i = 0; i < count; ++i) {
            RxCommand<C> command = AbstractStressTestBase.randomOf(commands);
            CompletionStage<Void> execution = command.execute(context);
            executions[i] = execution.toCompletableFuture();
        }
        return CompletableFuture.allOf(executions);
    }

    private List<Future<?>> launchAsyncWorkerThreads(C context) {
        List<AsyncCommand<C>> commands = this.createAsyncCommands();
        ArrayList futures = new ArrayList();
        for (int i = 0; i < THREAD_COUNT; ++i) {
            Future<Void> future = this.launchAsyncWorkerThread(this.executor, commands, context);
            futures.add(future);
        }
        return futures;
    }

    private List<AsyncCommand<C>> createAsyncCommands() {
        ArrayList<AsyncCommand<C>> commands = new ArrayList<AsyncCommand<C>>();
        commands.add(new AsyncReadQueryWithRetries((Driver)this.driver, false));
        commands.add(new AsyncReadQueryWithRetries((Driver)this.driver, true));
        commands.add(new AsyncWriteQueryWithRetries(this, (Driver)this.driver, false));
        commands.add(new AsyncWriteQueryWithRetries(this, (Driver)this.driver, true));
        commands.add(new AsyncWrongQueryWithRetries((Driver)this.driver));
        commands.add(new AsyncFailingQueryWithRetries((Driver)this.driver));
        return commands;
    }

    private Future<Void> launchAsyncWorkerThread(ExecutorService executor, List<AsyncCommand<C>> commands, C context) {
        return executor.submit(() -> {
            while (!context.isStopped()) {
                CompletableFuture<Void> allCommands = this.executeAsyncCommands(context, commands, ASYNC_BATCH_SIZE);
                Assertions.assertNull((Object)allCommands.get());
            }
            return null;
        });
    }

    private CompletableFuture<Void> executeAsyncCommands(C context, List<AsyncCommand<C>> commands, int count) {
        CompletableFuture[] executions = new CompletableFuture[count];
        for (int i = 0; i < count; ++i) {
            AsyncCommand<C> command = AbstractStressTestBase.randomOf(commands);
            CompletionStage<Void> execution = command.execute(context);
            executions[i] = execution.toCompletableFuture();
        }
        return CompletableFuture.allOf(executions);
    }

    private ResourcesInfo sleepAndGetResourcesInfo() throws InterruptedException {
        int halfSleepSeconds = Math.max(1, EXECUTION_TIME_SECONDS / 2);
        TimeUnit.SECONDS.sleep(halfSleepSeconds);
        ResourcesInfo resourcesInfo = this.getResourcesInfo();
        TimeUnit.SECONDS.sleep(halfSleepSeconds);
        return resourcesInfo;
    }

    private ResourcesInfo getResourcesInfo() {
        long openFileDescriptorCount = AbstractStressTestBase.getOpenFileDescriptorCount();
        Set<String> acquiredLoggerNames = this.logging.getAcquiredLoggerNames();
        return new ResourcesInfo(openFileDescriptorCount, acquiredLoggerNames);
    }

    private void verifyResults(C context, ResourcesInfo resourcesInfo) {
        this.assertNoFileDescriptorLeak(resourcesInfo.openFileDescriptorCount);
        this.assertNoLoggersLeak(resourcesInfo.acquiredLoggerNames);
        this.assertExpectedNumberOfNodesCreated(((AbstractContext)context).getCreatedNodesCount());
    }

    private void assertNoFileDescriptorLeak(long previousOpenFileDescriptors) {
        System.out.println("Initially open file descriptors: " + previousOpenFileDescriptors);
        long maxOpenFileDescriptors = (long)((double)previousOpenFileDescriptors * 1.5);
        long currentOpenFileDescriptorCount = AbstractStressTestBase.getOpenFileDescriptorCount();
        System.out.println("Currently open file descriptors: " + currentOpenFileDescriptorCount);
        MatcherAssert.assertThat((String)"Unexpectedly high number of open file descriptors", (Object)currentOpenFileDescriptorCount, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(maxOpenFileDescriptors)));
    }

    private void assertNoLoggersLeak(Set<String> previousAcquiredLoggerNames) {
        Set<String> currentAcquiredLoggerNames = this.logging.getAcquiredLoggerNames();
        MatcherAssert.assertThat((String)"Unexpected amount of logger instances", currentAcquiredLoggerNames, (Matcher)Matchers.equalTo(previousAcquiredLoggerNames));
    }

    private void assertExpectedNumberOfNodesCreated(long expectedCount) {
        try (Session session = this.driver.session();){
            List records = session.run("MATCH (n) RETURN count(n) AS nodesCount").list();
            Assertions.assertEquals((int)1, (int)records.size());
            Record record = (Record)records.get(0);
            long actualCount = record.get("nodesCount").asLong();
            Assertions.assertEquals((long)expectedCount, (long)actualCount, (String)"Unexpected number of nodes in the database");
        }
    }

    private static long getOpenFileDescriptorCount() {
        try {
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            Method method = osBean.getClass().getDeclaredMethod("getOpenFileDescriptorCount", new Class[0]);
            method.setAccessible(true);
            return (Long)method.invoke((Object)osBean, new Object[0]);
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private static Throwable withSuppressed(Throwable firstError, Throwable newError) {
        if (firstError == null) {
            return newError;
        }
        firstError.addSuppressed(newError);
        return firstError;
    }

    private static <T> T randomOf(List<T> elements) {
        int index = ThreadLocalRandom.current().nextInt(elements.size());
        return elements.get(index);
    }

    private static int bigDataTestBatchCount() {
        if (BIG_DATA_TEST_NODE_COUNT < BIG_DATA_TEST_BATCH_SIZE) {
            return 1;
        }
        return BIG_DATA_TEST_NODE_COUNT / BIG_DATA_TEST_BATCH_SIZE;
    }

    private static Bookmark createNodesBlocking(int batchCount, int batchSize, Driver driver) {
        Bookmark bookmark;
        long start = System.nanoTime();
        try (Session session = driver.session();){
            int i = 0;
            while (i < batchCount) {
                int batchIndex = i++;
                session.writeTransaction(tx -> AbstractStressTestBase.createNodesInTx(tx, batchIndex, batchSize));
            }
            bookmark = session.lastBookmark();
        }
        long end = System.nanoTime();
        System.out.println("Node creation with blocking API took: " + TimeUnit.NANOSECONDS.toMillis(end - start) + "ms");
        return bookmark;
    }

    private static void readNodesBlocking(Driver driver, Bookmark bookmark, int expectedNodeCount) {
        long start = System.nanoTime();
        try (Session session = driver.session(SessionConfig.builder().withBookmarks(new Bookmark[]{bookmark}).build());){
            int nodesProcessed = (Integer)session.readTransaction(tx -> {
                Result result = tx.run("MATCH (n:Node) RETURN n");
                int nodesSeen = 0;
                while (result.hasNext()) {
                    Node node = result.next().get(0).asNode();
                    ++nodesSeen;
                    List labels = Iterables.asList((Iterable)node.labels());
                    Assertions.assertEquals((int)2, (int)labels.size());
                    Assertions.assertTrue((boolean)labels.contains("Test"));
                    Assertions.assertTrue((boolean)labels.contains("Node"));
                    AbstractStressTestBase.verifyNodeProperties(node);
                }
                return nodesSeen;
            });
            Assertions.assertEquals((int)expectedNodeCount, (int)nodesProcessed);
        }
        long end = System.nanoTime();
        System.out.println("Reading nodes with blocking API took: " + TimeUnit.NANOSECONDS.toMillis(end - start) + "ms");
    }

    private static Bookmark createNodesAsync(int batchCount, int batchSize, Driver driver) throws Throwable {
        long start = System.nanoTime();
        AsyncSession session = driver.asyncSession();
        CompletionStage<Object> writeTransactions = CompletableFuture.completedFuture(null);
        int i = 0;
        while (i < batchCount) {
            int batchIndex = i++;
            writeTransactions = writeTransactions.thenCompose(ignore -> session.writeTransactionAsync(tx -> AbstractStressTestBase.createNodesInTxAsync(tx, batchIndex, batchSize)));
        }
        Throwable error2 = (Throwable)Futures.blockingGet(writeTransactions = ((CompletableFuture)writeTransactions.exceptionally(error -> error)).thenCompose(error -> AbstractStressTestBase.safeCloseSession(session, error)));
        if (error2 != null) {
            throw error2;
        }
        long end = System.nanoTime();
        System.out.println("Node creation with async API took: " + TimeUnit.NANOSECONDS.toMillis(end - start) + "ms");
        return session.lastBookmark();
    }

    private static void readNodesAsync(Driver driver, Bookmark bookmark, int expectedNodeCount) throws Throwable {
        AtomicInteger nodesSeen;
        long start = System.nanoTime();
        AsyncSession session = driver.asyncSession(SessionConfig.builder().withBookmarks(new Bookmark[]{bookmark}).build());
        CompletionStage readQuery = session.readTransactionAsync(arg_0 -> AbstractStressTestBase.lambda$readNodesAsync$11(nodesSeen = new AtomicInteger(), arg_0)).thenApply(summary -> null).exceptionally(error -> error).thenCompose(error -> AbstractStressTestBase.safeCloseSession(session, error));
        Throwable error2 = (Throwable)Futures.blockingGet(readQuery);
        if (error2 != null) {
            throw error2;
        }
        Assertions.assertEquals((int)expectedNodeCount, (int)nodesSeen.get());
        long end = System.nanoTime();
        System.out.println("Reading nodes with async API took: " + TimeUnit.NANOSECONDS.toMillis(end - start) + "ms");
    }

    private Bookmark createNodesRx(int batchCount, int batchSize, InternalDriver driver) {
        long start = System.nanoTime();
        RxSession session = driver.rxSession();
        Flux.concat((Publisher)Flux.range((int)0, (int)batchCount).map(batchIndex -> session.writeTransaction(tx -> this.createNodesInTxRx(tx, (int)batchIndex, batchSize)))).blockLast();
        long end = System.nanoTime();
        System.out.println("Node creation with reactive API took: " + TimeUnit.NANOSECONDS.toMillis(end - start) + "ms");
        return session.lastBookmark();
    }

    private Publisher<Void> createNodesInTxRx(RxTransaction tx, int batchIndex, int batchSize) {
        return Flux.concat((Publisher)Flux.range((int)0, (int)batchSize).map(index -> batchIndex * batchSize + index).map(nodeIndex -> {
            Query query = AbstractStressTestBase.createNodeInTxQuery(nodeIndex);
            return Flux.from((Publisher)tx.run(query).consume()).then();
        }));
    }

    private void readNodesRx(InternalDriver driver, Bookmark bookmark, int expectedNodeCount) {
        long start = System.nanoTime();
        RxSession session = driver.rxSession(SessionConfig.builder().withBookmarks(new Bookmark[]{bookmark}).build());
        AtomicInteger nodesSeen = new AtomicInteger();
        Publisher readQuery = session.readTransaction(tx -> Flux.from((Publisher)tx.run("MATCH (n:Node) RETURN n").records()).doOnNext(record -> {
            Node node = record.get(0).asNode();
            nodesSeen.incrementAndGet();
            List labels = Iterables.asList((Iterable)node.labels());
            Assertions.assertEquals((int)2, (int)labels.size());
            Assertions.assertTrue((boolean)labels.contains("Test"));
            Assertions.assertTrue((boolean)labels.contains("Node"));
            AbstractStressTestBase.verifyNodeProperties(node);
        }).then());
        Flux.from((Publisher)readQuery).blockLast();
        Assertions.assertEquals((int)expectedNodeCount, (int)nodesSeen.get());
        long end = System.nanoTime();
        System.out.println("Reading nodes with async API took: " + TimeUnit.NANOSECONDS.toMillis(end - start) + "ms");
    }

    private static Void createNodesInTx(Transaction tx, int batchIndex, int batchSize) {
        for (int index = 0; index < batchSize; ++index) {
            int nodeIndex = batchIndex * batchSize + index;
            AbstractStressTestBase.createNodeInTx(tx, nodeIndex);
        }
        return null;
    }

    private static void createNodeInTx(Transaction tx, int nodeIndex) {
        Query query = AbstractStressTestBase.createNodeInTxQuery(nodeIndex);
        tx.run(query).consume();
    }

    private static CompletionStage<Throwable> createNodesInTxAsync(AsyncTransaction tx, int batchIndex, int batchSize) {
        CompletableFuture[] queryFutures = (CompletableFuture[])IntStream.range(0, batchSize).map(index -> batchIndex * batchSize + index).mapToObj(nodeIndex -> AbstractStressTestBase.createNodeInTxAsync(tx, nodeIndex)).toArray(CompletableFuture[]::new);
        return ((CompletableFuture)CompletableFuture.allOf(queryFutures).thenApply(ignored -> null)).exceptionally(error -> error);
    }

    private static CompletableFuture<Void> createNodeInTxAsync(AsyncTransaction tx, int nodeIndex) {
        Query query = AbstractStressTestBase.createNodeInTxQuery(nodeIndex);
        return tx.runAsync(query).thenCompose(ResultCursor::consumeAsync).thenApply(ignore -> null).toCompletableFuture();
    }

    private static Query createNodeInTxQuery(int nodeIndex) {
        String query = "CREATE (n:Test:Node) SET n = $props";
        Map<String, Map<String, Object>> params = Collections.singletonMap("props", AbstractStressTestBase.createNodeProperties(nodeIndex));
        return new Query(query, params);
    }

    private static Map<String, Object> createNodeProperties(int nodeIndex) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("index", nodeIndex);
        result.put("name", "name-" + nodeIndex);
        result.put("surname", "surname-" + nodeIndex);
        result.put("long-indices", Collections.nCopies(10, Long.valueOf(nodeIndex)));
        result.put("double-indices", Collections.nCopies(10, Double.valueOf(nodeIndex)));
        result.put("booleans", Collections.nCopies(10, nodeIndex % 2 == 0));
        return result;
    }

    private static void verifyNodeProperties(Node node) {
        int nodeIndex = node.get("index").asInt();
        Assertions.assertEquals((Object)("name-" + nodeIndex), (Object)node.get("name").asString());
        Assertions.assertEquals((Object)("surname-" + nodeIndex), (Object)node.get("surname").asString());
        Assertions.assertEquals(Collections.nCopies(10, Long.valueOf(nodeIndex)), (Object)node.get("long-indices").asList());
        Assertions.assertEquals(Collections.nCopies(10, Double.valueOf(nodeIndex)), (Object)node.get("double-indices").asList());
        Assertions.assertEquals(Collections.nCopies(10, nodeIndex % 2 == 0), (Object)node.get("booleans").asList());
    }

    private static <T> CompletionStage<T> safeCloseSession(AsyncSession session, T result) {
        return session.closeAsync().exceptionally(ignore -> null).thenApply(ignore -> result);
    }

    private static /* synthetic */ CompletionStage lambda$readNodesAsync$11(AtomicInteger nodesSeen, AsyncTransaction tx) {
        return tx.runAsync("MATCH (n:Node) RETURN n").thenCompose(cursor -> cursor.forEachAsync(record -> {
            Node node = record.get(0).asNode();
            nodesSeen.incrementAndGet();
            List labels = Iterables.asList((Iterable)node.labels());
            Assertions.assertEquals((int)2, (int)labels.size());
            Assertions.assertTrue((boolean)labels.contains("Test"));
            Assertions.assertTrue((boolean)labels.contains("Node"));
            AbstractStressTestBase.verifyNodeProperties(node);
        }));
    }

    private static class LoggerNameTrackingLogging
    implements Logging {
        private final Logging consoleLogging = Logging.console((Level)Level.FINE);
        private final Set<String> acquiredLoggerNames = ConcurrentHashMap.newKeySet();

        private LoggerNameTrackingLogging() {
        }

        public Logger getLog(String name) {
            this.acquiredLoggerNames.add(name);
            if (DEBUG_LOGGING_ENABLED) {
                return this.consoleLogging.getLog(name);
            }
            return DevNullLogger.DEV_NULL_LOGGER;
        }

        Set<String> getAcquiredLoggerNames() {
            return new HashSet<String>(this.acquiredLoggerNames);
        }
    }

    private static class ResourcesInfo {
        final long openFileDescriptorCount;
        final Set<String> acquiredLoggerNames;

        ResourcesInfo(long openFileDescriptorCount, Set<String> acquiredLoggerNames) {
            this.openFileDescriptorCount = openFileDescriptorCount;
            this.acquiredLoggerNames = acquiredLoggerNames;
        }
    }
}

