/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.stress.AbstractAsyncQuery;
import org.neo4j.driver.stress.AbstractContext;

public class AsyncWrongQueryInTx<C extends AbstractContext>
extends AbstractAsyncQuery<C> {
    public AsyncWrongQueryInTx(Driver driver) {
        super(driver, false);
    }

    @Override
    public CompletionStage<Void> execute(C context) {
        AsyncSession session = this.newSession(AccessMode.READ, context);
        return session.beginTransactionAsync().thenCompose(tx -> tx.runAsync("RETURN Wrong").thenCompose(ResultCursor::nextAsync).handle((record, error) -> {
            Assertions.assertNull((Object)record);
            Throwable cause = Futures.completionExceptionCause((Throwable)error);
            Assertions.assertNotNull((Object)cause);
            MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ClientException.class));
            MatcherAssert.assertThat((Object)((Neo4jException)cause).code(), (Matcher)Matchers.containsString((String)"SyntaxError"));
            return tx;
        })).thenCompose(AsyncTransaction::rollbackAsync).whenComplete((ignore, error) -> session.closeAsync());
    }
}

