/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.stress.AbstractBlockingQuery;
import org.neo4j.driver.stress.AbstractContext;

public class BlockingFailingQueryInTx<C extends AbstractContext>
extends AbstractBlockingQuery<C> {
    public BlockingFailingQueryInTx(Driver driver) {
        super(driver, false);
    }

    @Override
    public void execute(C context) {
        try (Session session = this.newSession(AccessMode.READ, context);
             Transaction tx = this.beginTransaction(session, context);){
            Result result = tx.run("UNWIND [10, 5, 0] AS x RETURN 10 / x");
            Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> ((Result)result).consume());
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.arithmeticError()));
        }
    }
}

