/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.stress.AbstractBlockingQuery;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.summary.ResultSummary;

public class BlockingFailingQueryWithRetries<C extends AbstractContext>
extends AbstractBlockingQuery<C> {
    public BlockingFailingQueryWithRetries(Driver driver) {
        super(driver, false);
    }

    @Override
    public void execute(C context) {
        try (Session session = this.newSession(AccessMode.READ, context);){
            Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
                ResultSummary cfr_ignored_0 = (ResultSummary)session.readTransaction(tx -> tx.run("UNWIND [10, 5, 0] AS x RETURN 10 / x").consume());
            });
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.arithmeticError()));
        }
    }
}

