/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.stress.AbstractBlockingQuery;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.AbstractStressTestBase;
import org.neo4j.driver.summary.ResultSummary;

public class BlockingWriteQuery<C extends AbstractContext>
extends AbstractBlockingQuery<C> {
    private AbstractStressTestBase<C> stressTest;

    public BlockingWriteQuery(AbstractStressTestBase<C> stressTest, Driver driver, boolean useBookmark) {
        super(driver, useBookmark);
        this.stressTest = stressTest;
    }

    @Override
    public void execute(C context) {
        Throwable queryError;
        ResultSummary summary;
        block15: {
            summary = null;
            queryError = null;
            try (Session session = this.newSession(AccessMode.WRITE, context);){
                summary = session.run("CREATE ()").consume();
                ((AbstractContext)context).setBookmark(session.lastBookmark());
            }
            catch (Throwable error) {
                queryError = error;
                if (this.stressTest.handleWriteFailure(error, context)) break block15;
                throw error;
            }
        }
        if (queryError == null && summary != null) {
            Assertions.assertEquals((int)1, (int)summary.counters().nodesCreated());
            ((AbstractContext)context).nodeCreated();
        }
    }
}

