/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.stress.AbstractBlockingQuery;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.summary.ResultSummary;

public class BlockingWrongQueryWithRetries<C extends AbstractContext>
extends AbstractBlockingQuery<C> {
    public BlockingWrongQueryWithRetries(Driver driver) {
        super(driver, false);
    }

    @Override
    public void execute(C context) {
        try (Session session = this.newSession(AccessMode.READ, context);){
            Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
                ResultSummary cfr_ignored_0 = (ResultSummary)session.readTransaction(tx -> tx.run("RETURN").consume());
            });
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.syntaxError()));
        }
    }
}

